/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include "flNetwork.h"
#include <winsock2.h>
#include <ws2tcpip.h>
#include <mmsystem.h>
//------------------------------------------------------------------------------
flInt callInitializeCount = 0;
//------------------------------------------------------------------------------
flBool __stdcall
flNetwork::initialize()
{
	if (callInitializeCount == 0)
	{
		// Initialize WinSock
		WSADATA data;
		if (WSAStartup(MAKEWORD(2, 0), &data))
		{
			return false;
		}
		if (LOBYTE(data.wVersion) != 2 || HIBYTE(data.wVersion) != 0)
		{
			return false;
		}

		// Setup Timer Resolution
		TIMECAPS tc;
		timeGetDevCaps(&tc, sizeof(TIMECAPS));
		timeBeginPeriod(tc.wPeriodMin);

		// Setup Localhosts
		flChar buf[256];
		if (gethostname(buf, 256) == 0)
		{
			addrinfo hints, *res, *res2;
			memset(&hints, 0, sizeof(addrinfo));
//////	Depend on Address family
			hints.ai_family = AF_INET;
//////
			hints.ai_socktype = SOCK_STREAM;

			flInt ret = getaddrinfo(buf, NULL, &hints, &res);

			if (ret == 0)
			{
				flChar hbuf[256];
				flChar sbuf[256];

				res2 = res;

				while(res2 != NULL)
				{
					getnameinfo(res2->ai_addr, res2->ai_addrlen, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf),
						NI_NUMERICHOST | NI_NUMERICSERV);

					res2 = res2->ai_next;

					_localhost = flString(hbuf);
				}

				freeaddrinfo(res);
			}
		}

	}

	callInitializeCount++;
	return true;
}
//------------------------------------------------------------------------------
flBool __stdcall
flNetwork::shutdown()
{
	callInitializeCount --;
	if (callInitializeCount < 0)
		callInitializeCount = 0;

	if (callInitializeCount == 0)
	{
		// Clear Timer Resolution
		TIMECAPS tc;
		timeGetDevCaps(&tc, sizeof(TIMECAPS));
		timeEndPeriod(tc.wPeriodMin);

		// Shutdown WinSock
		WSACleanup();
	}
	return true;
}
//------------------------------------------------------------------------------
flBool __stdcall
flNetwork::isInitialized()
{
	return (1 <= callInitializeCount);
}
//------------------------------------------------------------------------------
const flString& __stdcall
flNetwork::getLocalhost()
{
	return _localhost;
}
//------------------------------------------------------------------------------
flNetwork::flNetwork()
{
}
//------------------------------------------------------------------------------
flNetwork::~flNetwork()
{
}
//------------------------------------------------------------------------------
flString	flNetwork::_localhost;
//------------------------------------------------------------------------------
