/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __NONLINEARZOOM_H__
#define __NONLINEARZOOM_H__

class CPointerInputPin;

class CNonLinearZoom : public CTransformN3Filter,
		public CPersistStream, 
		public INonLinearZoom,
		public ISpecifyPropertyPages
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

	// Reveals INonLinearZoom & ISpecifyPropertyPages
    STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    DECLARE_IUNKNOWN;

	virtual int				GetPinCount();
	virtual CBasePin*		GetPin(int n);
	virtual STDMETHODIMP	FindPin(LPCWSTR Id, IPin **ppPin);

	HRESULT Transform(IMediaSample *pIn, IMediaSample *pOut);
    HRESULT CheckInputType(const CMediaType *mtIn);
	HRESULT CheckOutputType(const CMediaType *mtOut);

    virtual HRESULT			SetMediaType(PIN_DIRECTION direction,const CMediaType *pmt);

	HRESULT GetMediaType(int iPosition, CMediaType *pMediaType);
    HRESULT DecideBufferSize(IMemAllocator *pAlloc,
                             ALLOCATOR_PROPERTIES *pProperties);

    // INonLinearZoom methods
	STDMETHODIMP get_OutputVideoResolution(unsigned int *videoResolution);
	STDMETHODIMP put_OutputVideoResolution(unsigned int videoResolution);
	STDMETHODIMP get_Mask(unsigned int *mask);
	STDMETHODIMP put_Mask(unsigned int mask);
	STDMETHODIMP get_MaskPosition(int* x, int* y);
	STDMETHODIMP put_MaskPosition(int x, int y);
	STDMETHODIMP get_MaskSize(int* width, int* height);
	STDMETHODIMP put_MaskSize(int width, int height);
	STDMETHODIMP get_PointerInDisable(bool* flag);
	STDMETHODIMP put_PointerInDisable(bool flag);

	// IPersistStream
    STDMETHODIMP GetClassID(CLSID *pClsid);
	HRESULT WriteToStream(IStream *pStream);
    HRESULT ReadFromStream(IStream *pStream);
	DWORD GetSoftwareVersion(void);
	int SizeMax ();


    // ISpecifyPropertyPages method
    STDMETHODIMP GetPages(CAUUID *pPages);

	// Other
	HRESULT		ReceivePointer(IMediaSample *pSource,CPointerInputPin *ppin);

	CCritSec&	getCSFilter(){ return m_csFilter; }
	CCritSec&	getCSReceive(){ return m_csReceive; }

private:

    // Constructor
    CNonLinearZoom(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CNonLinearZoom();

	HRESULT Zoom(IMediaSample *pSource, IMediaSample *pDest) const;

	HRESULT AllocBaseBuffer(unsigned int size);
	HRESULT CreateEllipseMaskInfo(int width, int height);
	HRESULT DrawBaseBufferInBGColor();

    // Non interface locking critical section
    CCritSec m_NonLinearZoomLock;


private:

	CPointerInputPin		*_pPointer;

	VideoResolutionEnum		_outVR;
	MaskEnum				_mask;
	int						_maskPosX;
	int						_maskPosY;
	int						_maskSizeWidth;
	int						_maskSizeHeight;
	bool					_pointerInDisable;

	int						_baseBufSize;
	BYTE*					_baseBuf;

	bool					_maskSizeIsChanged;
	int						_elipMaskInfoSize;
	short*					_elipMaskInfo;
	int						_emW;
	int						_emH;
	int						_emHW;
	int						_emHH;

	flPointerInfo			_pointerInfo;

}; // CNonLinearZoom

class CPointerInputPin : public CBaseInputPin
{
    friend class CTransformN3Filter;

protected:
	  CNonLinearZoom *m_pTransformFilter;

public:

    CPointerInputPin(
        TCHAR *pObjectName,
        CTransformN3Filter *pTransformFilter,
        HRESULT * phr,
        LPCWSTR pName);

#if 0
    STDMETHODIMP QueryId(LPWSTR * Id)
    {
        return AMGetWideString(L"pIn", Id);
    }
#endif

	// Grab and release extra interfaces if required
    HRESULT CheckConnect(IPin *pPin);
    HRESULT BreakConnect();
    HRESULT CompleteConnect(IPin *pReceivePin);

    // check that we can support this output type
    HRESULT CheckMediaType(const CMediaType* mtIn);

    // set the connection media type
    HRESULT SetMediaType(const CMediaType* mt);

    // --- IMemInputPin -----

    // here's the next block of data from the stream.
    // AddRef it yourself if you need to hold it beyond the end
    // of this call.
    STDMETHODIMP Receive(IMediaSample * pSample);

    // provide EndOfStream that passes straight downstream
    // (there is no queued data)
    STDMETHODIMP EndOfStream(void);

    // passes it to CTransformN3Filter::BeginFlush
    STDMETHODIMP BeginFlush(void);

    // passes it to CTransformN3Filter::EndFlush
    STDMETHODIMP EndFlush(void);

    STDMETHODIMP NewSegment(
                        REFERENCE_TIME tStart,
                        REFERENCE_TIME tStop,
                        double dRate);

    // Check if it's OK to process samples
    virtual HRESULT CheckStreaming();

    // Media type
public:
    CMediaType& CurrentMediaType() { return m_mt; };

};

#endif
