/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#include <streams.h>
#include <commctrl.h>
#include <olectl.h>
#include <memory.h>
#include "resource.h"

#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include "transfrmn3.h"

#include <flFilterCommon/flPointerInfo.h>
#include <flTypes/flUIDs.h>
#include <flTypes/INonLinearZoom.h>

#include "nonlinearzoom.h"
#include "nonlinearzoomprop.h"


//
// CreateInstance
//
// This goes in the factory template table to create new filter instances
//
CUnknown * WINAPI CNonLinearZoomProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CNonLinearZoomProperties(lpunk, phr);
    if (punk == NULL) {
	*phr = E_OUTOFMEMORY;
    }
    return punk;

} // CreateInstance


//
// Constructor
//
CNonLinearZoomProperties::CNonLinearZoomProperties(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("NonLinearZoomProp"),pUnk,
                      IDD_NONLINEARZOOMPROP,
                      IDS_TITLE),
    m_pNonLinearZoom(NULL)
{
    InitCommonControls();

} // (Constructor)


//
// SetDirty
//
// Sets m_bDirty and notifies the property page site of the change
//
void CNonLinearZoomProperties::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite) {
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

} // SetDirty


//
// OnReceiveMessage
//
// Virtual method called by base class with Window messages
//
BOOL CNonLinearZoomProperties::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			SetupItems();

			return (LRESULT) 1;

		}
        case WM_COMMAND:
        {

			switch(LOWORD(wParam))
			{
			case IDC_OUT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO));
					pINonLinearZoom()->put_OutputVideoResolution(sel);
					SetDirty();
				}
				break;
			case IDC_MASK_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO));
					pINonLinearZoom()->put_Mask(sel);

					SetDirty();
				}
				break;
			case IDC_MASKPOSX_EDIT:
			case IDC_MASKPOSY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int x, y;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_MASKPOSX_EDIT), sz, STR_MAX_LENGTH);
					x = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MASKPOSY_EDIT), sz, STR_MAX_LENGTH);
					y = atoi(sz);
					pINonLinearZoom()->put_MaskPosition(x, y);

					SetDirty();
				}
				break;
			case IDC_MASKSIZEWIDTH_EDIT:
			case IDC_MASKSIZEHEIGHT_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int width, height;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_MASKSIZEWIDTH_EDIT), sz, STR_MAX_LENGTH);
					width = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MASKSIZEHEIGHT_EDIT), sz, STR_MAX_LENGTH);
					height = atoi(sz);
					pINonLinearZoom()->put_MaskSize(width, height);

					SetDirty();
				}
				break;
			case IDC_PINDISABLE_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK)) == TRUE);
					pINonLinearZoom()->put_PointerInDisable(flag);

					SetDirty();
				}
				break;
			}

			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);

} // OnReceiveMessage


//
// OnConnect
//
// Called when the property page connects to a filter
//
HRESULT CNonLinearZoomProperties::OnConnect(IUnknown *pUnknown)
{
    ASSERT(m_pNonLinearZoom == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_INonLinearZoom, (void **) &m_pNonLinearZoom);
    if (FAILED(hr)) {
        return E_NOINTERFACE;
    }

    ASSERT(m_pNonLinearZoom);

	m_pNonLinearZoom->get_OutputVideoResolution(&_iOutputVideoResolution);
	_iOutputVideoResolutionOnExit = _iOutputVideoResolution;

	m_pNonLinearZoom->get_Mask(&_iMask);
	_iMaskOnExit = _iMask;

	m_pNonLinearZoom->get_MaskPosition(&_iMaskPosX, &_iMaskPosY);
	_iMaskPosXOnExit = _iMaskPosX;
	_iMaskPosYOnExit = _iMaskPosY;

	m_pNonLinearZoom->get_MaskSize(&_iMaskSizeWidth, &_iMaskSizeHeight);
	_iMaskSizeWidthOnExit = _iMaskSizeWidth;
	_iMaskSizeHeightOnExit = _iMaskSizeHeight;

	m_pNonLinearZoom->get_PointerInDisable(&_bPointerInDisable);
	_bPointerInDisableOnExit = _bPointerInDisable;

	return NOERROR;

} // OnConnect


//
// OnDisconnect
//
// Called when we're disconnected from a filter
//
HRESULT CNonLinearZoomProperties::OnDisconnect()
{
    if (m_pNonLinearZoom == NULL) {
        return E_UNEXPECTED;
    }

	m_pNonLinearZoom->put_OutputVideoResolution(_iOutputVideoResolutionOnExit);
	m_pNonLinearZoom->put_Mask(_iMaskOnExit);
	m_pNonLinearZoom->put_MaskPosition(_iMaskPosXOnExit, _iMaskPosYOnExit);
	m_pNonLinearZoom->put_MaskSize(_iMaskSizeWidthOnExit, _iMaskSizeHeightOnExit);
	m_pNonLinearZoom->put_PointerInDisable(_bPointerInDisableOnExit);

    m_pNonLinearZoom->Release();
    m_pNonLinearZoom = NULL;
    return NOERROR;

} // OnDisconnect


//
// OnDeactivate
//
// We are being deactivated
//
HRESULT CNonLinearZoomProperties::OnDeactivate(void)
{
	pINonLinearZoom()->get_OutputVideoResolution(&_iOutputVideoResolution);
	pINonLinearZoom()->get_Mask(&_iMask);
	pINonLinearZoom()->get_MaskPosition(&_iMaskPosX, &_iMaskPosY);
	pINonLinearZoom()->get_MaskSize(&_iMaskSizeWidth, &_iMaskSizeHeight);
	pINonLinearZoom()->get_PointerInDisable(&_bPointerInDisable);

	return NOERROR;

} // OnDeactivate


//
// OnApplyChanges
//
// Changes made should be kept. Change the m_cNonLinearZoomOnExit variable
//
HRESULT CNonLinearZoomProperties::OnApplyChanges()
{
	pINonLinearZoom()->get_OutputVideoResolution(&_iOutputVideoResolutionOnExit);
	pINonLinearZoom()->get_Mask(&_iMaskOnExit);
	pINonLinearZoom()->get_MaskPosition(&_iMaskPosXOnExit, &_iMaskPosYOnExit);
	pINonLinearZoom()->get_MaskSize(&_iMaskSizeWidthOnExit, &_iMaskSizeHeightOnExit);
	pINonLinearZoom()->get_PointerInDisable(&_bPointerInDisableOnExit);

    m_bDirty = FALSE;
    return(NOERROR);

} // OnApplyChanges

void
CNonLinearZoomProperties::SetupItems()
{
	ComboBox_ResetContent(m_Dlg);
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SQCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("QCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("CIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("160x120"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("320x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("360x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("640x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("720x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("800x600"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1024x768"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1280x1024"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1600x1200"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 720p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 1080i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480i"));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("`"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("ȉ~"));

	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _iOutputVideoResolution);
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _iMask);

    TCHAR   sz[32];
    _stprintf(sz, TEXT("%d"), _iMaskPosX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MASKPOSX_EDIT), sz);
    _stprintf(sz, TEXT("%d"), _iMaskPosY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MASKPOSY_EDIT), sz);

    _stprintf(sz, TEXT("%d"), _iMaskSizeWidth);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MASKSIZEWIDTH_EDIT), sz);
    _stprintf(sz, TEXT("%d"), _iMaskSizeHeight);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MASKSIZEHEIGHT_EDIT), sz);

	Button_SetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK), _bPointerInDisable);
}




