/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

class CNonLinearZoomProperties : public CBasePropertyPage
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:

    BOOL	OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT	OnConnect(IUnknown *pUnknown);
    HRESULT	OnDisconnect();
    HRESULT	OnDeactivate();
    HRESULT	OnApplyChanges();

    void	SetDirty();
	void	SetupItems();

    CNonLinearZoomProperties(LPUNKNOWN lpunk, HRESULT *phr);
	
	unsigned int	_iOutputVideoResolution;
	unsigned int	_iOutputVideoResolutionOnExit;
	unsigned int	_iMask;
	unsigned int	_iMaskOnExit;
	int				_iMaskPosX;
	int				_iMaskPosXOnExit;
	int				_iMaskPosY;
	int				_iMaskPosYOnExit;
	int				_iMaskSizeWidth;
	int				_iMaskSizeWidthOnExit;
	int				_iMaskSizeHeight;
	int				_iMaskSizeHeightOnExit;
	bool			_bPointerInDisable;
	bool			_bPointerInDisableOnExit;

    INonLinearZoom	*m_pNonLinearZoom;

    INonLinearZoom *pINonLinearZoom() {
        ASSERT(m_pNonLinearZoom);
        return m_pNonLinearZoom;
    };

}; // CNonLinearZoomProperties

