/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#include "stdafx.h"

#include <windows.h>

int _tmain(int argc, _TCHAR* argv[])
{
	char bitmapfile[1024];
	int originX, originY;

	printf("Input bitmap(24bit) file ");
	scanf("%s", bitmapfile);

	printf("original X = ");
	scanf("%d", &originX);

	printf("original Y = ");
	scanf("%d", &originY);

	FILE* fp = fopen(bitmapfile, "rb");

	if (fp != NULL)
	{
		BITMAPFILEHEADER	header;
		BITMAPINFO			info;

		if (fread(&header, 1, sizeof(BITMAPFILEHEADER), fp) < sizeof(BITMAPFILEHEADER))
		{
			printf("Cannot read bitmap file [%s]\n", bitmapfile);
			goto ERROR_EXIT;
		}

		if (fread(&info, 1, sizeof(BITMAPINFOHEADER), fp) < sizeof(BITMAPINFOHEADER))
		{
			printf("Cannot read bitmap file [%s]\n", bitmapfile);
			goto ERROR_EXIT;
		}

		if (info.bmiHeader.biBitCount != 24)
		{
			printf("Read bitmap file is not 24bit [%s]\n", bitmapfile);
			goto ERROR_EXIT;
		}

		unsigned char *data = new unsigned char[info.bmiHeader.biSizeImage];

		if (fread(data, 1, info.bmiHeader.biSizeImage, fp) < info.bmiHeader.biSizeImage)
		{
			printf("Cannot read bitmap file [%s]\n", bitmapfile);
			return 0;
		}

		char str[256];

		// Output
		printf("%d, %d,\n", originX, originY);
		printf("{");
		for(unsigned int i = 0; i < info.bmiHeader.biSizeImage; i++)
		{
			if (i % 12 == 0)
				printf("\n");

			sprintf(str, "0x%2x, ", data[i]);
			if (str[2] == ' ')	str[2] = '0';
			printf("%s", str);
		}
		printf("\n}\n");

        delete data;
		fclose(fp);
	}

ERROR_EXIT:
	getchar();
	getchar();

	return 0;
}

