/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerInfoInputPin_h__
#define __PointerInfoInputPin_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flPointerInfo.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerMixer;
//------------------------------------------------------------------------------
class CPointerInfoInputPin : public CTransformInputPin
{
	friend class CPointerMixer;

public:
	CPointerInfoInputPin(TCHAR *pObjName,
						CPointerMixer *pointerMixer,
						HRESULT *phr,
						LPCWSTR pPinName);
	~CPointerInfoInputPin();

public:

    STDMETHODIMP			QueryId(LPWSTR * Id);

	// CBasePin virtual
	HRESULT					CheckConnect(IPin *pPin);
	HRESULT					BreakConnect();
	HRESULT					CompleteConnect(IPin *pReceivePin);
	HRESULT					SetMediaType(const CMediaType* pmt);

	// CBasePin Pure virtual
	HRESULT					CheckMediaType(const CMediaType* pmt);

	// CUnknown Override
	STDMETHODIMP_(ULONG)	NonDelegatingAddRef();
	STDMETHODIMP_(ULONG)	NonDelegatingRelease();

	// CTransformInputPin Override
	STDMETHODIMP			Receive(IMediaSample * pSample);
	STDMETHODIMP			EndOfStream(void);
	STDMETHODIMP			BeginFlush(void);
	STDMETHODIMP			EndFlush(void);
	STDMETHODIMP			NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate);

protected:
    CPointerMixer*	_pointerMixer;
    flLong			_referenceCount;

	CCritSec		_pinLock;
	flBool			_pinValid;
	flULong			_pinReceiveTime;
	flPointerInfo	_pointerInfo;
};
//------------------------------------------------------------------------------
DECLARE_SAFE_COPYFUNC(CPointerInfoInputPin);
DECLARE_SAFE_COMPFUNC(CPointerInfoInputPin);
//------------------------------------------------------------------------------
#endif //__PointerInfoInputPin_h__
