/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerMixer_h__
#define __PointerMixer_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flTextDraw.h>
#include <flFilterCommon/flLocusDraw.h>
#include <flFilterCommon/flPointerDraw.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IPointerMixer.h>
#include <flTypes/IPointerPosition.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#define MAXIMUM_POINTERINFOPINS		1024
#define POINTERLOSTTIME				3000
//------------------------------------------------------------------------------
class CPointerMixer : public CTransInPlaceFilter,
					public CPersistStream, 
					public IPointerMixer,
					public ISpecifyPropertyPages
{
	friend class CPointerInfoInputPin;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CPointerMixer(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	~CPointerMixer();

public:
    STDMETHODIMP			NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    virtual	int				GetPinCount();
    virtual CBasePin*		GetPin(int n);
    STDMETHODIMP			FindPin(LPCWSTR Id, IPin **ppPin);
	virtual HRESULT SetMediaType(PIN_DIRECTION direction,const CMediaType *pmt);

    virtual HRESULT			Transform(IMediaSample *pSample);
	virtual HRESULT			CheckInputType(const CMediaType *mtIn);

	// IPersistStream
    STDMETHODIMP			GetClassID(CLSID *pClsid);
	HRESULT					WriteToStream(IStream *pStream);
    HRESULT					ReadFromStream(IStream *pStream);
	DWORD					GetSoftwareVersion(void);
	int						SizeMax();

    // ISpecifyPropertyPages
    STDMETHODIMP			GetPages(CAUUID *pPages);

    // IPointerMixer
	STDMETHODIMP			get_WindowPosition(flFloat *x, flFloat *y);
	STDMETHODIMP			put_WindowPosition(flFloat x, flFloat y);
	STDMETHODIMP			get_WindowSize(flFloat *width, flFloat *height);
	STDMETHODIMP			put_WindowSize(flFloat width, flFloat height);
	STDMETHODIMP			get_MappingPosition(flFloat *x, flFloat *y);
	STDMETHODIMP			put_MappingPosition(flFloat x, flFloat y);
	STDMETHODIMP			get_MappingSize(flFloat *width, flFloat *height);
	STDMETHODIMP			put_MappingSize(flFloat width, flFloat height);
	STDMETHODIMP			get_NumPointerInput(flUInt* numPointerInput);
	STDMETHODIMP			get_NumPointerShape(flUInt *count);
	STDMETHODIMP			add_PointerShape(const flChar * filename);
	STDMETHODIMP			remove_PointerShape(flUInt index);
	STDMETHODIMP			get_PointerShapeName(flUInt index, flChar * filename);
	STDMETHODIMP			put_PointerShapeName(flUInt index, const flChar * filename);
	STDMETHODIMP			get_PointerShapeOrigin(flUInt index, flInt* originX, flInt* originY);
	STDMETHODIMP			put_PointerShapeOrigin(flUInt index, flInt originX, flInt originY);

private:
	void					InitPointerInfoInputPins();
	void					CreateInputPin(CPointerMixer* owner);
	void					DeleteInputPin(CPointerInfoInputPin* inputPin);
	flUInt					GetNumFreePins();

private:
	void					updatePinValid();
	void					drawUpperLayer(BYTE *data);
	void					drawLowerLayer(BYTE *data);

private:
	void					createDefaultPointerDraws();

protected:
	// Ciritcal Section for filter
    CCritSec				_filterLock;

	flUInt					_nextInputPinNumber;
	flArray<CPointerInfoInputPin *>	_pointerInfoInputPins;

	flUInt					_videoWidth;
	flUInt					_videoHeight;

	flArray<flPointerDraw*>	_pointerDraws;
	flArray<flLocusDraw *>	_locusDraws;
	flArray<flTextDraw *>	_phraseDraws;

	// Properties
	flFloat					_windowPositionX;
	flFloat					_windowPositionY;
	flFloat					_windowWidth;
	flFloat					_windowHeight;
	flFloat					_mappingPositionX;
	flFloat					_mappingPositionY;
	flFloat					_mappingWidth;
	flFloat					_mappingHeight;
};
//------------------------------------------------------------------------------
#endif // __PointerMixer_h__
