/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flPointerMixer/PointerMixerExtProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CPointerMixerExtProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CPointerMixerExtProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CPointerMixerExtProp::CPointerMixerExtProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("PointerMixerExtProp"),pUnk,
                      IDD_POINTERMIXEREXTPROP,
                      IDS_POINTERMIXEREXTPROPTITLE),
    _pointerMixer(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CPointerMixerExtProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_POINTERSHAPEADD_BUTTON:
				addPointer();
				resetPointerShapeList();
				writePointerShapeList();

				updatePointerOrigins();

				writePointerShapeOriginX();
				writePointerShapeOriginY();

				break;

			case IDC_POINTERSHAPEREMOVE_BUTTON:
				removePointer();
				resetPointerShapeList();
				writePointerShapeList();

				updatePointerOrigins();

				writePointerShapeOriginX();
				writePointerShapeOriginY();

				break;

			case IDC_POINTERSHAPE_LIST:
				if (HIWORD(wParam) == LBN_SELCHANGE)
				{
					readPointerShapeList();

					writePointerShapeOriginX();
					writePointerShapeOriginY();
				}
				break;
				
			case IDC_POINTERSHAPEORIGINX_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPointerShapeOriginX();
				break;

			case IDC_POINTERSHAPEORIGINY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPointerShapeOriginY();
				break;

			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerExtProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_pointerMixer == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IPointerMixer, (void **) &_pointerMixer);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_pointerMixer);

	// Current Pointer Shape index
	_currentPointerShape = 0;

	// Get Pointer Shape Origin
	updatePointerOrigins();

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerExtProp::OnDisconnect()
{
    if (_pointerMixer == NULL)
	{
        return E_UNEXPECTED;
    }

    _pointerMixer->Release();
    _pointerMixer = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerExtProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerExtProp::OnApplyChanges()
{
    m_bDirty = FALSE;

	for(flUInt i = 0; i < _origins.getSize(); i++)
	{
		flInt orgX, orgY;
		orgX = (flInt)_origins[i].x;
		orgY = (flInt)_origins[i].y;
		_pointerMixer->put_PointerShapeOrigin(i, orgX, orgY);
	}

    return NOERROR;
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::setupControls()
{
	// Setup Controls
	resetPointerShapeList();
	writePointerShapeList();
	writePointerShapeOriginX();
	writePointerShapeOriginY();
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::writePointerShapeList()
{
	if (_origins.getSize() == 0)
		return ;
	ListBox_SetCurSel(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST), _currentPointerShape);
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::readPointerShapeList()
{
	_currentPointerShape = ListBox_GetCurSel(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST));
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::writePointerShapeOriginX()
{
	if (_origins.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _origins[_currentPointerShape].x);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPEORIGINX_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::readPointerShapeOriginX()
{
	if (_origins.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPEORIGINX_EDIT), sz, STR_MAX_LENGTH);
	_origins[_currentPointerShape].x = _tstoi(sz);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::writePointerShapeOriginY()
{
	if (_origins.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _origins[_currentPointerShape].y);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPEORIGINY_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::readPointerShapeOriginY()
{
	if (_origins.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPEORIGINY_EDIT), sz, STR_MAX_LENGTH);
	_origins[_currentPointerShape].y = _tstoi(sz);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::resetPointerShapeList()
{
	TCHAR sz[STR_MAX_LENGTH];
	flUInt numPointerShapes;

	ListBox_ResetContent(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST));

	_pointerMixer->get_NumPointerShape(&numPointerShapes);
	for(flUInt i = 0; i < numPointerShapes; i++)
	{
		_pointerMixer->get_PointerShapeName(i, sz); // sz is TCHAR ??? 
		ListBox_AddString(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST), sz);
	}
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::addPointer()
{
	HWND userPointerList = GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST);
	flChar name[MAX_PATH];
	memset(name, 0, MAX_PATH);

	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= m_Dlg;
	ofn.hInstance		= (HINSTANCE)GetModuleHandle(NULL);
	ofn.lpstrFilter		= "Image File\0*.bmp\0\0";
	ofn.lpstrFile		= name;
	ofn.nMaxFile		= MAX_PATH;
	ofn.lpstrTitle		= NULL;
	ofn.lpstrInitialDir	= NULL;
	ofn.Flags			= OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

	if (GetOpenFileName(&ofn))
	{
		TCHAR str[1024];
		_stprintf(str, "Ǎ݂Ɏs܂B %d  %d sNZȉ 24-bit rbg}bvt@CłKv܂B",
			PM_MAXIMUM_POINTERSHAPEWIDTH, PM_MAXIMUM_POINTERSHAPEHEIGHT);
		if (_pointerMixer->add_PointerShape(name) != NOERROR)
			MessageBox(m_Dlg, str, "G[", MB_OK);
	}
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::removePointer()
{
    HWND userPointerList = GetDlgItem(m_Dlg, IDC_POINTERSHAPE_LIST);

	if (_pointerMixer->remove_PointerShape(_currentPointerShape) != NOERROR)
		MessageBox(m_Dlg, "g݂̃|C^`͍폜ł܂B", "G[", MB_OK);
}
//------------------------------------------------------------------------------
void
CPointerMixerExtProp::updatePointerOrigins()
{
	flUInt numPointerShapes;
	_pointerMixer->get_NumPointerShape(&numPointerShapes);

	_origins.setSize(0);
	_origins.setGrowSize(16);
	for(flUInt i = 0; i < numPointerShapes; i++)
	{
		POINT point;
		_pointerMixer->get_PointerShapeOrigin(i, (flInt *)&point.x, (flInt *)&point.y);
		_origins.add(point);
	}
}
//------------------------------------------------------------------------------
