/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerMixerExtProp_h__
#define __PointerMixerExtProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IPointerMixer.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerMixerExtProp : public CBasePropertyPage
{
public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CPointerMixerExtProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
	// Item Access
	void		writePointerShapeList();
	void		readPointerShapeList();
	void		writePointerShapeOriginX();
	void		readPointerShapeOriginX();
	void		writePointerShapeOriginY();
	void		readPointerShapeOriginY();
	void		resetPointerShapeList();
	void		addPointer();
	void		removePointer();

	void		updatePointerOrigins();

private:
    IPointerMixer*	_pointerMixer;

	flArray<POINT>	_origins;
	flInt			_currentPointerShape;
};
//------------------------------------------------------------------------------
#endif //__PointerMixerExtProp_h__
