/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flPointerMixer/PointerMixerProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CPointerMixerProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CPointerMixerProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CPointerMixerProp::CPointerMixerProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("PointerMixerProp"),pUnk,
                      IDD_POINTERMIXERPROP,
                      IDS_POINTERMIXERPROPTITLE),
    _pointerMixer(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CPointerMixerProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CPointerMixerProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_WINDOWPOSX_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_WINDOWPOSX_EDIT), sz, STR_MAX_LENGTH);
					_windowPositionX = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_WINDOWPOSY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_WINDOWPOSY_EDIT), sz, STR_MAX_LENGTH);
					_windowPositionY = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_WINDOWSIZEW_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_WINDOWSIZEW_EDIT), sz, STR_MAX_LENGTH);
					_windowWidth = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_WINDOWSIZEH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_WINDOWSIZEH_EDIT), sz, STR_MAX_LENGTH);
					_windowHeight = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_MAPPINGPOSX_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MAPPINGPOSX_EDIT), sz, STR_MAX_LENGTH);
					_mappingPositionX = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_MAPPINGPOSY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MAPPINGPOSY_EDIT), sz, STR_MAX_LENGTH);
					_mappingPositionY = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_MAPPINGSIZEW_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MAPPINGSIZEW_EDIT), sz, STR_MAX_LENGTH);
					_mappingWidth = (float)atof(sz);
					SetDirty();
				}
				break;
			case IDC_MAPPINGSIZEH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_MAPPINGSIZEH_EDIT), sz, STR_MAX_LENGTH);
					_mappingHeight = (float)atof(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_pointerMixer == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IPointerMixer, (void **) &_pointerMixer);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_pointerMixer);

	_pointerMixer->get_WindowPosition(&_windowPositionX, &_windowPositionY);
	_pointerMixer->get_WindowSize(&_windowWidth, &_windowHeight);
	_pointerMixer->get_MappingPosition(&_mappingPositionX, &_mappingPositionY);
	_pointerMixer->get_MappingSize(&_mappingWidth, &_mappingHeight);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerProp::OnDisconnect()
{
    if (_pointerMixer == NULL)
	{
        return E_UNEXPECTED;
    }

    _pointerMixer->Release();
    _pointerMixer = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerMixerProp::OnApplyChanges()
{
	_pointerMixer->put_WindowPosition(_windowPositionX, _windowPositionY);
	_pointerMixer->put_WindowSize(_windowWidth, _windowHeight);
	_pointerMixer->put_MappingPosition(_mappingPositionX, _mappingPositionY);
	_pointerMixer->put_MappingSize(_mappingWidth, _mappingHeight);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CPointerMixerProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[32];

	_stprintf(sz, "%5.3f", _windowPositionX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_WINDOWPOSX_EDIT), sz);

	_stprintf(sz, "%5.3f", _windowPositionY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_WINDOWPOSY_EDIT), sz);

	_stprintf(sz, "%5.3f", _windowWidth);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_WINDOWSIZEW_EDIT), sz);

	_stprintf(sz, "%5.3f", _windowHeight);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_WINDOWSIZEH_EDIT), sz);

	_stprintf(sz, "%5.3f", _mappingPositionX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MAPPINGPOSX_EDIT), sz);

	_stprintf(sz, "%5.3f", _mappingPositionY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MAPPINGPOSY_EDIT), sz);

	_stprintf(sz, "%5.3f", _mappingWidth);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MAPPINGSIZEW_EDIT), sz);

	_stprintf(sz, "%5.3f", _mappingHeight);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_MAPPINGSIZEH_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerMixerProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
