/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerMixerProp_h__
#define __PointerMixerProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IPointerMixer.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerMixerProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CPointerMixerProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IPointerMixer*	_pointerMixer;

	flFloat			_windowPositionX;
	flFloat			_windowPositionY;
	flFloat			_windowWidth;
	flFloat			_windowHeight;
	flFloat			_mappingPositionX;
	flFloat			_mappingPositionY;
	flFloat			_mappingWidth;
	flFloat			_mappingHeight;
};
//------------------------------------------------------------------------------
#endif //__PointerMixerProp_h__
