/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flBitmap_h__
#define __flBitmap_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
// Standard Pointer Shape bitmap
#define PSTANDARD_WIDTH		16
#define PSTANDARD_HEIGHT	16
#define PSTANDARD_ORGX		0
#define PSTANDARD_ORGY		0
extern const flChar PStandardName[];
extern const flByte PStandard[PSTANDARD_WIDTH * PSTANDARD_HEIGHT * 3];
//------------------------------------------------------------------------------
// Arrow Pointer Shape bitmap
#define PARROW_WIDTH		16
#define PARROW_HEIGHT		16
#define PARROW_ORGX			0
#define PARROW_ORGY			0
extern const flChar PArrowName[];
extern const flByte PArrow[PARROW_WIDTH * PARROW_HEIGHT * 3];
//------------------------------------------------------------------------------
// Circle Pointer Shape bitmap
#define PCIRCLE_WIDTH		16
#define PCIRCLE_HEIGHT		16
#define PCIRCLE_ORGX		7
#define PCIRCLE_ORGY		7
extern const flChar PCircleName[];
extern const flByte PCircle[PCIRCLE_WIDTH * PCIRCLE_HEIGHT * 3];
//------------------------------------------------------------------------------
// Rectangle Pointer Shape bitmap
#define PRECTANGLE_WIDTH	16
#define PRECTANGLE_HEIGHT	16
#define PRECTANGLE_ORGX		7
#define PRECTANGLE_ORGY		7
extern const flChar PRectangleName[];
extern const flByte PRectangle[PRECTANGLE_WIDTH * PRECTANGLE_HEIGHT * 3];
//------------------------------------------------------------------------------
// Target Pointer Shape bitmap
#define PTARGET_WIDTH		16
#define PTARGET_HEIGHT		16
#define PTARGET_ORGX		7
#define PTARGET_ORGY		7
extern const flChar PTargetName[];
extern const flByte PTarget[PTARGET_WIDTH * PTARGET_HEIGHT * 3];
//------------------------------------------------------------------------------
// Star Pointer Shape bitmap
#define PSTAR_WIDTH			16
#define PSTAR_HEIGHT		16
#define PSTAR_ORGX			7
#define PSTAR_ORGY			7
extern const flChar PStarName[];
extern const flByte PStar[PSTAR_WIDTH * PSTAR_HEIGHT * 3];
//------------------------------------------------------------------------------
#endif //__flBitmap_h__
//------------------------------------------------------------------------------
