/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerPosition_h__
#define __PointerPosition_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flPointerPosition/flLocusData.h>
#include <flPointerPosition/flPhraseData.h>
#include <flFilterCommon/flPointerInfo.h>
#include <flTypes/IPointerPosition.h>
#include <flTypes/flUIDs.h>
#include <flDirectInput/flMouse.h>
#include <flDirectInput/flMouseEnumerator.h>
#include <flDirectInput/flDirectInput.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerPositionStream;
//------------------------------------------------------------------------------
class CPointerPosition :
		public CSource,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IPointerPosition
{
	friend class CPointerPositionStream;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CPointerPosition(TCHAR *tszName, LPUNKNOWN pUnk, HRESULT *phr);
    ~CPointerPosition();

public:
	// Reveals IPointerPosition & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
	// IMediaFilter
	STDMETHODIMP	Run(REFERENCE_TIME startTime);
	STDMETHODIMP	Pause();
	STDMETHODIMP	Stop();

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();

    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// IPointerPosition
	// Monitor
	STDMETHODIMP	get_ScreenSize(flUShort *width, flUShort *height);
	STDMETHODIMP	get_PointerPosition(flUShort *x, flUShort *y);
	STDMETHODIMP	get_ButtonStatus(flUShort *status);
	STDMETHODIMP	get_WheelStatus(flUShort *status);
	STDMETHODIMP	get_NormalizedPointerPosition(flFloat *x, flFloat *y);
	// Standard Settings
	STDMETHODIMP	get_OutputMinimumPeriod(flULong *period);
	STDMETHODIMP	put_OutputMinimumPeriod(flULong period);
	STDMETHODIMP	get_PointerShape(flShort *pointerShape);
	STDMETHODIMP	put_PointerShape(flShort pointerShape);
	STDMETHODIMP	get_PointerColor(flByte *color);
	STDMETHODIMP	put_PointerColor(const flByte *color);
	STDMETHODIMP	get_NormalizedOrigin(flFloat *ox, flFloat *oy);
	STDMETHODIMP	put_NormalizedOrigin(flFloat ox, flFloat oy);
	STDMETHODIMP	get_NormalizedSize(flFloat *ow, flFloat *oh);
	STDMETHODIMP	put_NormalizedSize(flFloat ow, flFloat oh);
	// Locus Settings
	STDMETHODIMP	get_DrawLocusOn(flBool *flag);
	STDMETHODIMP	put_DrawLocusOn(flBool flag);
	STDMETHODIMP	get_LocusDrawButton(flUShort* buttonStatus);
	STDMETHODIMP	put_LocusDrawButton(flUShort buttonStatus);
	STDMETHODIMP	get_LocusEraseButton(flUShort* buttonStatus);
	STDMETHODIMP	put_LocusEraseButton(flUShort buttonStatus);
	STDMETHODIMP	get_LocusDrawPointerShape(flShort* shape);
	STDMETHODIMP	put_LocusDrawPointerShape(flShort shape);
	STDMETHODIMP	get_LocusDrawPointerColor(flByte *color);
	STDMETHODIMP	put_LocusDrawPointerColor(const flByte* color);
	STDMETHODIMP	get_LocusEdgingOn(flBool *flag);
	STDMETHODIMP	put_LocusEdgingOn(flBool flag);
	STDMETHODIMP	get_LocusBrokenLineOn(flBool *flag);
	STDMETHODIMP	put_LocusBrokenLineOn(flBool flag);
	STDMETHODIMP	get_LocusWidth(flUShort *width);
	STDMETHODIMP	put_LocusWidth(flUShort width);
	// Phrase Settings
	STDMETHODIMP	get_ShowPhraseOn(flBool *flag);
	STDMETHODIMP	put_ShowPhraseOn(flBool flag);
	STDMETHODIMP	get_NumPhrases(flUInt *count);
	STDMETHODIMP	put_NumPhrases(flUInt count);
	STDMETHODIMP	add_Phrase();
	STDMETHODIMP	remove_Phrase(flUInt index);
	STDMETHODIMP	get_Phrase(flUInt index, flChar *phrase);
	STDMETHODIMP	put_Phrase(flUInt index, const flChar *phrase);
	STDMETHODIMP	get_PhraseShowButton(flUInt index, flUShort* buttonStatus);
	STDMETHODIMP	put_PhraseShowButton(flUInt index, flUShort buttonStatus);
	STDMETHODIMP	get_PhraseShowPointerShape(flUInt index, flShort* shape);
	STDMETHODIMP	put_PhraseShowPointerShape(flUInt index, flShort shape);
	STDMETHODIMP	get_PhraseShowPointerColor(flUInt index, flByte *color);
	STDMETHODIMP	put_PhraseShowPointerColor(flUInt index, const flByte* color);
	// User Data
	STDMETHODIMP	get_UserData(flByte *userData, flUInt *size);
	STDMETHODIMP	put_UserData(const flByte *userData, flUInt size);

private:
	flBool			updatePointerInfo();

protected:
	// Ciritcal Section for filter
	CCritSec				_filterLock;

	// DirectInput Mouse Device
	flMouse*				_mouse;

	// Filter Status
	flBool					_isRunning;

	// PointerInfo
	flPointerInfo			_pointerInfo;

	// Properties
	flULong					_outputMinimumPeriod;
	flShort					_pointerShape;
	flByte					_pointerColor[3];
	flFloat					_normalizedOrigin[2];
	flFloat					_normalizedSize[2];
	flBool					_drawLocusOn;
	flBool					_showPhraseOn;
	flLocusData				_locusData;
	flArray<flPhraseData>	_phraseDatas;
	flUInt					_userDataSize;
	flByte					_userData[PP_MAXIMUM_USERDATA_SIZE];

protected:
	// Output Stream pin
	CPointerPositionStream*	_pointerPositionStream;

};
//------------------------------------------------------------------------------
#endif //__PointerPosition_h__
