/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flPointerPosition/PointerPositionExtProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <commdlg.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
#define BUTTONSTATUS2STR(__buttonStatus, __str)		\
{													\
	_stprintf(__str, "0000000000000000");			\
	for(flUInt i = 0x0001, index = 0; i <= 0x8000; i <<= 1, index++)	\
		if (((__buttonStatus) & i) != 0)			\
			__str[index] = '1';						\
}
//------------------------------------------------------------------------------
CUnknown * WINAPI
CPointerPositionExtProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CPointerPositionExtProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CPointerPositionExtProp::CPointerPositionExtProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("PointerPositionExtProp"),pUnk,
                      IDD_POINTERPOSITIONEXTPROP,
                      IDS_POINTERPOSITIONEXTPROPTITLE),
    _pointerPosition(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CPointerPositionExtProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			setupControls();
			return (LRESULT) 1;
		}
		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			// Locus Settings
			case IDC_DRAWLOCUSON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					readDrawLocusOn();
					setupEnableLocusGroup();
				}
				break;

			case IDC_LOCUSDRAWBUTTON_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusDrawButton();
				break;

			case IDC_LOCUSERASEBUTTON_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusEraseButton();
				break;

			case IDC_LOCUSPOINTERSHAPE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
					readLocusPointerShapeFromList();
				else if (HIWORD(wParam) == CBN_EDITCHANGE)
					readLocusPointerShapeFromEdit();
				break;

			case IDC_LOCUSPOINTERCOLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusPointerColorR();
				break;

			case IDC_LOCUSPOINTERCOLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusPointerColorG();
				break;

			case IDC_LOCUSPOINTERCOLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusPointerColorB();
				break;

			case IDC_LOCUSPOINTERCOLORREF_BUTTOn:
				readLocusPointerColorRef();
				break;

			case IDC_LOCUSEDGINGON_CHECK:
				readLocusEdgingOn();
				break;

			case IDC_LOCUSBROKENLINEON_CHECK:
				readLocusBrokenLineOn();
				break;

			case IDC_LOCUSWIDTH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readLocusWidth();
				break;

			// Phrase Settings
			case IDC_SHOWPHRASEON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					readShowPhraseOn();
					setupEnablePhraseGroup();
				}
				break;

			case IDC_PHRASESELECTION_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					readPhraseSelection();
					
					writePhrase();
					writePhraseShowButton();
					writePhrasePointerShape();
					writePhrasePointerColorR();
					writePhrasePointerColorG();
					writePhrasePointerColorB();
				}
				break;

			case IDC_PHRASEADD_BUTTON:
				{
					readPhraseAdd();

					writePhrase();
					writePhraseShowButton();
					writePhrasePointerShape();
					writePhrasePointerColorR();
					writePhrasePointerColorG();
					writePhrasePointerColorB();

					resetPhraseSelection();
					writePhraseSelection();

					setupEnablePhraseGroup();
				}
				break;

			case IDC_PHRASEREMOVE_BUTTON:
				{
					readPhraseRemove();

					writePhrase();
					writePhraseShowButton();
					writePhrasePointerShape();
					writePhrasePointerColorR();
					writePhrasePointerColorG();
					writePhrasePointerColorB();

					resetPhraseSelection();
					writePhraseSelection();

					setupEnablePhraseGroup();
				}
				break;

			case IDC_PHRASE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPhrase();
				break;

			case IDC_PHRASESHOWBUTTON_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPhraseShowButton();
					
				break;

			case IDC_PHRASEPOINTERSHAPE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
					readPhrasePointerShapeFromList();
				else if (HIWORD(wParam) == CBN_EDITCHANGE)
					readPhrasePointerShapeFromEdit();
				break;

			case IDC_PHRASEPOINTERCOLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPhrasePointerColorR();
				break;

			case IDC_PHRASEPOINTERCOLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPhrasePointerColorG();
				break;

			case IDC_PHRASEPOINTERCOLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
					readPhrasePointerColorB();
				break;

			case IDC_PHRASEPOINTERCOLORREF_BUTTON:
				readPhrasePointerColorRef();
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionExtProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_pointerPosition == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IPointerPosition, (void **) &_pointerPosition);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_pointerPosition);

	// Locus
	_pointerPosition->get_DrawLocusOn(&_drawLocusOn);
	_pointerPosition->get_LocusDrawButton(&_locusData.DrawButton);
	_pointerPosition->get_LocusEraseButton(&_locusData.EraseButton);
	_pointerPosition->get_LocusDrawPointerShape(&_locusData.DrawPointerShape);
	_pointerPosition->get_LocusDrawPointerColor(_locusData.DrawPointerColor);
	_pointerPosition->get_LocusEdgingOn(&_locusData.EdgingOn);
	_pointerPosition->get_LocusBrokenLineOn(&_locusData.BrokenLineOn);
	_pointerPosition->get_LocusWidth(&_locusData.Width);

	// Phrase
	_currentPhrase = 0;
	_pointerPosition->get_ShowPhraseOn(&_showPhraseOn);

    flUInt numPhrases;
	_pointerPosition->get_NumPhrases(&numPhrases);

	_phraseDatas.setSize(0);
	_phraseDatas.setGrowSize(16);

	for(flUInt i = 0; i < numPhrases; i++)
	{
		flPhraseData phraseData;
		_pointerPosition->get_Phrase(i, phraseData.Phrase);
		_pointerPosition->get_PhraseShowButton(i, &phraseData.ShowButton);
		_pointerPosition->get_PhraseShowPointerShape(i, &phraseData.ShowPointerShape);
		_pointerPosition->get_PhraseShowPointerColor(i, phraseData.ShowPointerColor);
		_phraseDatas.add(phraseData);
	}

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionExtProp::OnDisconnect()
{
    if (_pointerPosition == NULL)
	{
        return E_UNEXPECTED;
    }

    _pointerPosition->Release();
    _pointerPosition = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionExtProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionExtProp::OnApplyChanges()
{
	// Locus
	_pointerPosition->put_DrawLocusOn(_drawLocusOn);
	_pointerPosition->put_LocusDrawButton(_locusData.DrawButton);
	_pointerPosition->put_LocusEraseButton(_locusData.EraseButton);
	_pointerPosition->put_LocusDrawPointerShape(_locusData.DrawPointerShape);
	_pointerPosition->put_LocusDrawPointerColor(_locusData.DrawPointerColor);
	_pointerPosition->put_LocusEdgingOn(_locusData.EdgingOn);
	_pointerPosition->put_LocusBrokenLineOn(_locusData.BrokenLineOn);
	_pointerPosition->put_LocusWidth(_locusData.Width);

	// Phrase
	_pointerPosition->put_ShowPhraseOn(_showPhraseOn);
	
	_pointerPosition->put_NumPhrases(0);
	for(flUInt i = 0; i < _phraseDatas.getSize(); i++)
	{
		_pointerPosition->add_Phrase();
		_pointerPosition->put_Phrase(i, _phraseDatas[i].Phrase);
		_pointerPosition->put_PhraseShowButton(i, _phraseDatas[i].ShowButton);
		_pointerPosition->put_PhraseShowPointerShape(i, _phraseDatas[i].ShowPointerShape);
		_pointerPosition->put_PhraseShowPointerColor(i, _phraseDatas[i].ShowPointerColor);
	}

    m_bDirty = FALSE;
    return(NOERROR);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::setupControls()
{
	TCHAR sz[1024];

	// Locus
	HWND dlgItem = GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "W");
	ComboBox_AddString(dlgItem, "");
	ComboBox_AddString(dlgItem, "~");
	ComboBox_AddString(dlgItem, "lp");
	ComboBox_AddString(dlgItem, "Ə");
	ComboBox_AddString(dlgItem, "");

	setupEnableLocusGroup();
	writeDrawLocusOn();
	writeLocusDrawButton();
	writeLocusEraseButton();
	writeLocusPointerShape();
	writeLocusPointerColorR();
	writeLocusPointerColorG();
	writeLocusPointerColorB();
	writeLocusEdgingOn();
	writeLocusBrokenLineOn();
	writeLocusWidth();

	// Phrase
	resetPhraseSelection();

	dlgItem = GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "W");
	ComboBox_AddString(dlgItem, "");
	ComboBox_AddString(dlgItem, "~");
	ComboBox_AddString(dlgItem, "lp");
	ComboBox_AddString(dlgItem, "Ə");
	ComboBox_AddString(dlgItem, "");

	_stprintf(sz, "t[Y(ő%d)", PP_MAXIMUM_PHRASE_LENGTH);
	Static_SetText(GetDlgItem(m_Dlg, IDC_PHRASE_LABEL), sz);

	setupEnablePhraseGroup();
	writeShowPhraseOn();
	writePhraseSelection();
	writePhrase();
	writePhraseShowButton();
	writePhrasePointerShape();
	writePhrasePointerColorR();
	writePhrasePointerColorG();
	writePhrasePointerColorB();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::shutdownControls()
{
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeDrawLocusOn()
{
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_DRAWLOCUSON_CHECK),
		_drawLocusOn ? TRUE : FALSE);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readDrawLocusOn()
{
	_drawLocusOn = (Button_GetCheck(GetDlgItem(m_Dlg,
								IDC_DRAWLOCUSON_CHECK)) == TRUE);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusDrawButton()
{
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _locusData.DrawButton);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSDRAWBUTTON_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusDrawButton()
{
	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSDRAWBUTTON_EDIT), sz, STR_MAX_LENGTH);
	_locusData.DrawButton = (flUShort)_tstoi(sz);

	BUTTONSTATUS2STR(_locusData.DrawButton, sz);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSDRAWBUTTON_VALUE), sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusEraseButton()
{
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _locusData.EraseButton);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSERASEBUTTON_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusEraseButton()
{
	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSERASEBUTTON_EDIT), sz, STR_MAX_LENGTH);
	_locusData.EraseButton = (flUShort)_tstoi(sz);

	BUTTONSTATUS2STR(_locusData.EraseButton, sz);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSERASEBUTTON_VALUE), sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusPointerShape()
{
	flInt pointerShape = _locusData.DrawPointerShape;
	if (IPointerPosition::NUM_POINTERSHAPE <= pointerShape)
	{
		TCHAR sz[STR_MAX_LENGTH];
		_stprintf(sz, "No. %d", pointerShape);
		ComboBox_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_COMBO), sz);
	}
	else
	{
		ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_COMBO), pointerShape);
	}
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerShapeFromEdit()
{
	TCHAR sz[STR_MAX_LENGTH];
	ComboBox_GetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_COMBO), sz, STR_MAX_LENGTH);
	_locusData.DrawPointerShape = _tstoi(sz);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerShapeFromList()
{
	_locusData.DrawPointerShape = (flShort)ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
								IDC_LOCUSPOINTERSHAPE_COMBO));
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusPointerColorR()
{
	TCHAR sz[STR_MAX_LENGTH];

	_stprintf(sz, "%d", _locusData.DrawPointerColor[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORR_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusPointerColorG()
{
	TCHAR sz[STR_MAX_LENGTH];

	_stprintf(sz, "%d", _locusData.DrawPointerColor[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORG_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusPointerColorB()
{
	TCHAR sz[STR_MAX_LENGTH];

	_stprintf(sz, "%d", _locusData.DrawPointerColor[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORB_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerColorR()
{
	TCHAR sz[STR_MAX_LENGTH];

	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORR_EDIT), sz, STR_MAX_LENGTH);
	_locusData.DrawPointerColor[0] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerColorG()
{
	TCHAR sz[STR_MAX_LENGTH];

	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORG_EDIT), sz, STR_MAX_LENGTH);
	_locusData.DrawPointerColor[1] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerColorB()
{
	TCHAR sz[STR_MAX_LENGTH];

	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORB_EDIT), sz, STR_MAX_LENGTH);
	_locusData.DrawPointerColor[2] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusPointerColorRef()
{
	COLORREF color;
	COLORREF custColors[16];

	color = RGB(_locusData.DrawPointerColor[0],
				_locusData.DrawPointerColor[1],
				_locusData.DrawPointerColor[2]);

	CHOOSECOLOR cc;
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize	= sizeof(CHOOSECOLOR);
	cc.hwndOwner	= NULL;
	cc.rgbResult	= color;
	cc.lpCustColors	= custColors;
	cc.Flags	= CC_FULLOPEN | CC_RGBINIT;
	if (ChooseColor(&cc) == TRUE)
	{
		TCHAR sz[STR_MAX_LENGTH];

		_stprintf(sz, TEXT("%d"), GetRValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORR_EDIT), sz);

		_stprintf(sz, TEXT("%d"), GetGValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORG_EDIT), sz);

		_stprintf(sz, TEXT("%d"), GetBValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORB_EDIT), sz);
	}
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusEdgingOn()
{
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_LOCUSEDGINGON_CHECK), _locusData.EdgingOn ? TRUE : FALSE);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusEdgingOn()
{
	_locusData.EdgingOn = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_LOCUSEDGINGON_CHECK)) == TRUE);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusBrokenLineOn()
{
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_LOCUSBROKENLINEON_CHECK), _locusData.BrokenLineOn ? TRUE : FALSE);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusBrokenLineOn()
{
	_locusData.BrokenLineOn = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_LOCUSBROKENLINEON_CHECK)) == TRUE);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeLocusWidth()
{
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _locusData.Width);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_LOCUSWIDTH_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readLocusWidth()
{
	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_LOCUSWIDTH_EDIT), sz, STR_MAX_LENGTH);
	_locusData.Width = (flUShort)_tstoi(sz);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writeShowPhraseOn()
{
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_SHOWPHRASEON_CHECK),
		_showPhraseOn ? TRUE : FALSE);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readShowPhraseOn()
{
	_showPhraseOn = (Button_GetCheck(GetDlgItem(m_Dlg,
								IDC_SHOWPHRASEON_CHECK)) == TRUE);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhraseSelection()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_PHRASESELECTION_COMBO), 
		(flInt)_currentPhrase);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhraseSelection()
{
	_currentPhrase = (flShort)ComboBox_GetCurSel(
		GetDlgItem(m_Dlg, IDC_PHRASESELECTION_COMBO));
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhraseAdd()
{
	//
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhraseAdd()
{
	_phraseDatas.add(flPhraseData());
	_currentPhrase = _phraseDatas.getSize() - 1;
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhraseRemove()
{
	//
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhraseRemove()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	_phraseDatas.removeIndex(_currentPhrase);
	if (_currentPhrase == _phraseDatas.getSize())
		_currentPhrase--;
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhrase()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[PP_MAXIMUM_PHRASE_LENGTH];
	_stprintf(sz, "%s", _phraseDatas[_currentPhrase].Phrase);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASE_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrase()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[PP_MAXIMUM_PHRASE_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_PHRASE_EDIT), sz, PP_MAXIMUM_PHRASE_LENGTH);
	strcpy(_phraseDatas[_currentPhrase].Phrase, sz);	// convert from TCHAR ??
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhraseShowButton()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _phraseDatas[_currentPhrase].ShowButton);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASESHOWBUTTON_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhraseShowButton()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_PHRASESHOWBUTTON_EDIT), sz, STR_MAX_LENGTH);
	_phraseDatas[_currentPhrase].ShowButton = (flUShort)_tstoi(sz);

	BUTTONSTATUS2STR(_phraseDatas[_currentPhrase].ShowButton, sz);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASESHOWBUTTON_VALUE), sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhrasePointerShape()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	flInt pointerShape =(flInt)_phraseDatas[_currentPhrase].ShowPointerShape;
	if (IPointerPosition::NUM_POINTERSHAPE <= pointerShape)
	{
		TCHAR sz[STR_MAX_LENGTH];
		_stprintf(sz, "No. %d", pointerShape);
		ComboBox_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO), sz);
	}
	else
	{
		ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO), pointerShape);
	}
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerShapeFromEdit()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[STR_MAX_LENGTH];
	ComboBox_GetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO), sz, STR_MAX_LENGTH);
	_phraseDatas[_currentPhrase].ShowPointerShape = _tstoi(sz);
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerShapeFromList()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	_phraseDatas[_currentPhrase].ShowPointerShape = 
		(flShort)ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO));
	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhrasePointerColorR()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _phraseDatas[_currentPhrase].ShowPointerColor[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORR_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhrasePointerColorG()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _phraseDatas[_currentPhrase].ShowPointerColor[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORG_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::writePhrasePointerColorB()
{
	if (_phraseDatas.getSize() == 0)
		return ;
	TCHAR sz[STR_MAX_LENGTH];
	_stprintf(sz, "%d", _phraseDatas[_currentPhrase].ShowPointerColor[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORB_EDIT), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerColorR()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORR_EDIT), sz, STR_MAX_LENGTH);
	_phraseDatas[_currentPhrase].ShowPointerColor[0] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerColorG()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORG_EDIT), sz, STR_MAX_LENGTH);
	_phraseDatas[_currentPhrase].ShowPointerColor[1] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerColorB()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	TCHAR sz[STR_MAX_LENGTH];
	Edit_GetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORB_EDIT), sz, STR_MAX_LENGTH);
	_phraseDatas[_currentPhrase].ShowPointerColor[2] = (flByte)_tstoi(sz);

	SetDirty();
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::readPhrasePointerColorRef()
{
	if (_phraseDatas.getSize() == 0)
		return ;

	COLORREF color;
	COLORREF custColors[16];

	color = RGB(_phraseDatas[_currentPhrase].ShowPointerColor[0],
				_phraseDatas[_currentPhrase].ShowPointerColor[1],
				_phraseDatas[_currentPhrase].ShowPointerColor[2]);

	CHOOSECOLOR cc;
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize	= sizeof(CHOOSECOLOR);
	cc.hwndOwner	= NULL;
	cc.rgbResult	= color;
	cc.lpCustColors	= custColors;
	cc.Flags	= CC_FULLOPEN | CC_RGBINIT;
	if (ChooseColor(&cc) == TRUE)
	{
		TCHAR sz[STR_MAX_LENGTH];

		_stprintf(sz, TEXT("%d"), GetRValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORR_EDIT), sz);

		_stprintf(sz, TEXT("%d"), GetGValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORG_EDIT), sz);

		_stprintf(sz, TEXT("%d"), GetBValue(cc.rgbResult));
		Edit_SetText(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORB_EDIT), sz);
	}
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::setupEnableLocusGroup()
{
	BOOL flag = (_drawLocusOn ? TRUE : FALSE);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSDRAWBUTTON_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSERASEBUTTON_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLOR_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSWIDTH_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORR_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORG_LABE), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORB_LABEL), flag);
	Button_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORREF_BUTTOn), flag);
	Button_Enable(GetDlgItem(m_Dlg, IDC_LOCUSEDGINGON_CHECK), flag);
	Button_Enable(GetDlgItem(m_Dlg, IDC_LOCUSBROKENLINEON_CHECK), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSDRAWBUTTON_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSERASEBUTTON_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORR_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORG_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERCOLORB_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_LOCUSWIDTH_EDIT), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_LOCUSPOINTERSHAPE_COMBO), flag);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::setupEnablePhraseGroup()
{
	BOOL flag = (_showPhraseOn ? TRUE : FALSE);
	Button_Enable(GetDlgItem(m_Dlg, IDC_PHRASEADD_BUTTON), flag);

	flag &= ((_phraseDatas.getSize() != 0) ? TRUE : FALSE);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASE_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASESHOWBUTTON_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLOR_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORR_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORG_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORB_LABEL), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_PHRASE_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_PHRASESHOWBUTTON_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORR_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORG_EDIT), flag);
	Edit_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORB_EDIT), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_PHRASESELECTION_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERSHAPE_COMBO), flag);
	Button_Enable(GetDlgItem(m_Dlg, IDC_PHRASEREMOVE_BUTTON), flag);
	Button_Enable(GetDlgItem(m_Dlg, IDC_PHRASEPOINTERCOLORREF_BUTTON), flag);
}
//------------------------------------------------------------------------------
void
CPointerPositionExtProp::resetPhraseSelection()
{
	TCHAR sz[STR_MAX_LENGTH];

	HWND dlgItem = GetDlgItem(m_Dlg, IDC_PHRASESELECTION_COMBO);
	ComboBox_ResetContent(dlgItem);
	for(flUInt i = 0; i < _phraseDatas.getSize(); i++)
	{
		_stprintf(sz, "t[Y:%d", (i + 1));
		ComboBox_AddString(dlgItem, sz);
	}
}
//------------------------------------------------------------------------------
#undef BUTTONSTATUS2STR
//------------------------------------------------------------------------------
