/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerPositionExtProp_h__
#define __PointerPositionExtProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flPointerPosition/flLocusData.h>
#include <flPointerPosition/flPhraseData.h>
#include <flTypes/IPointerPosition.h>
#include <flTypes/flUIDs.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerPositionExtProp : public CBasePropertyPage
{
public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CPointerPositionExtProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
	// Item Access
	void		writeDrawLocusOn();
	void		readDrawLocusOn();
	void		writeLocusDrawButton();
	void		readLocusDrawButton();
	void		writeLocusEraseButton();
	void		readLocusEraseButton();
	void		writeLocusPointerShape();
	void		readLocusPointerShapeFromEdit();
	void		readLocusPointerShapeFromList();
	void		writeLocusPointerColorR();
	void		writeLocusPointerColorG();
	void		writeLocusPointerColorB();
	void		readLocusPointerColorR();
	void		readLocusPointerColorG();
	void		readLocusPointerColorB();
	void		readLocusPointerColorRef();
	void		writeLocusEdgingOn();
	void		readLocusEdgingOn();
	void		writeLocusBrokenLineOn();
	void		readLocusBrokenLineOn();
	void		writeLocusWidth();
	void		readLocusWidth();

	void		writeShowPhraseOn();
	void		readShowPhraseOn();
	void		writePhraseSelection();
	void		readPhraseSelection();
	void		writePhraseAdd();
	void		readPhraseAdd();
	void		writePhraseRemove();
	void		readPhraseRemove();
	void		writePhrase();
	void		readPhrase();
	void		writePhraseShowButton();
	void		readPhraseShowButton();
	void		writePhrasePointerShape();
	void		readPhrasePointerShapeFromEdit();
	void		readPhrasePointerShapeFromList();
	void		writePhrasePointerColorR();
	void		writePhrasePointerColorG();
	void		writePhrasePointerColorB();
	void		readPhrasePointerColorR();
	void		readPhrasePointerColorG();
	void		readPhrasePointerColorB();
	void		readPhrasePointerColorRef();

	void		setupEnableLocusGroup();
	void		setupEnablePhraseGroup();

	void		resetPhraseSelection();

private:
    IPointerPosition*		_pointerPosition;

	flBool					_drawLocusOn;
	flLocusData				_locusData;

	flBool					_showPhraseOn;
	flArray<flPhraseData>	_phraseDatas;
	flUInt					_currentPhrase;
};
//------------------------------------------------------------------------------
#endif //__PointerPositionExtProp_h__
