/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flPointerPosition/PointerPositionProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <commdlg.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CPointerPositionProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CPointerPositionProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CPointerPositionProp::CPointerPositionProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("PointerPositionProp"),pUnk,
                      IDD_POINTERPOSITIONPROP,
                      IDS_POINTERPOSITIONPROPTITLE),
    _pointerPosition(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CPointerPositionProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CPointerPositionProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_OUTPUTMINPERIOD_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_OUTPUTMINPERIOD_EDIT), sz, STR_MAX_LENGTH);
					_outputMinimumPeriod = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERSHAPE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_pointerShape = (flShort)ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_POINTERSHAPE_COMBO));
					SetDirty();
				}
				else if (HIWORD(wParam) == CBN_EDITCHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					ComboBox_GetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_COMBO), sz, STR_MAX_LENGTH);
					_pointerShape = _tstoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERCOLORR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORR_EDIT), sz, STR_MAX_LENGTH);
					_pointerColor[0] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERCOLORG_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORG_EDIT), sz, STR_MAX_LENGTH);
					_pointerColor[1] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERCOLORB_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORB_EDIT), sz, STR_MAX_LENGTH);
					_pointerColor[2] = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_POINTERCOLORREF_BUTTON:
				{
					COLORREF color;
					COLORREF custColors[16];

					color = RGB(_pointerColor[0], _pointerColor[1], _pointerColor[2]);

					CHOOSECOLOR cc;
					memset(&cc, 0, sizeof(CHOOSECOLOR));
					cc.lStructSize	= sizeof(CHOOSECOLOR);
					cc.hwndOwner	= NULL;
					cc.rgbResult	= color;
					cc.lpCustColors	= custColors;
					cc.Flags	= CC_FULLOPEN | CC_RGBINIT;
					if (ChooseColor(&cc) == TRUE)
					{
						TCHAR sz[STR_MAX_LENGTH];
						_stprintf(sz, TEXT("%d"), GetRValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORR_EDIT), sz);
						_stprintf(sz, TEXT("%d"), GetGValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORG_EDIT), sz);
						_stprintf(sz, TEXT("%d"), GetBValue(cc.rgbResult));
						Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORB_EDIT), sz);
					}
				}
				break;
			case IDC_NORMORIGINOX_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_NORMORIGINOX_EDIT), sz, STR_MAX_LENGTH);
					_normalizedOriginX = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_NORMORIGINOY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_NORMORIGINOY_EDIT), sz, STR_MAX_LENGTH);
					_normalizedOriginY = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_NORMSIZEOW_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_NORMSIZEOW_EDIT), sz, STR_MAX_LENGTH);
					_normalizedWidth = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_NORMSIZEOH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_NORMSIZEOH_EDIT), sz, STR_MAX_LENGTH);
					_normalizedHeight = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR sz[STR_MAX_LENGTH];
			flFloat fval1, fval2;
			flUShort sval, sval1, sval2;

			// Screen size
			_pointerPosition->get_ScreenSize(&sval1, &sval2);
			_stprintf(sz, "%d", sval1);
			Static_SetText(GetDlgItem(m_Dlg, IDC_PIXELW_VALUE), sz);
			_stprintf(sz, "%d", sval2);
			Static_SetText(GetDlgItem(m_Dlg, IDC_PIXELH_VALUE), sz);

			// Pointer position
			_pointerPosition->get_PointerPosition(&sval1, &sval2);
			_stprintf(sz, "%d", sval1);
			Static_SetText(GetDlgItem(m_Dlg, IDC_POINTERPOSX_VALUE), sz);
			_stprintf(sz, "%d", sval2);
			Static_SetText(GetDlgItem(m_Dlg, IDC_POINTERPOSY_VALUE), sz);

			// Button status
			_pointerPosition->get_ButtonStatus(&sval);
			_stprintf(sz, "0000000000000000");
			for(int i = 0x0001, index = 0; i <= 0x8000; i <<= 1, index++)
				if ((sval & i) != 0)
					sz[index] = '1';
			Static_SetText(GetDlgItem(m_Dlg, IDC_BUTTONSTATUS_VALUE), sz);

			// Wheel status
			_pointerPosition->get_WheelStatus(&sval);
			_stprintf(sz, "%x", sval);
			Static_SetText(GetDlgItem(m_Dlg, IDC_WHEELSTATUS_VALUE), sz);

			// Normalized Pointer position
			_pointerPosition->get_NormalizedPointerPosition(&fval1, &fval2);
			_stprintf(sz, "%5.3f", fval1);
			Static_SetText(GetDlgItem(m_Dlg, IDC_NORMPOINTERPOSX_VALUE), sz);
			_stprintf(sz, "%5.3f", fval2);
			Static_SetText(GetDlgItem(m_Dlg, IDC_NORMPOINTERPOSY_VALUE), sz);

			Sleep(0);

			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_pointerPosition == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IPointerPosition, (void **) &_pointerPosition);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_pointerPosition);

	_pointerPosition->get_OutputMinimumPeriod((flULong *)&_outputMinimumPeriod);
	_pointerPosition->get_PointerShape(&_pointerShape);
	_pointerPosition->get_PointerColor(_pointerColor);
	_pointerPosition->get_NormalizedOrigin(&_normalizedOriginX, &_normalizedOriginY);
	_pointerPosition->get_NormalizedSize(&_normalizedWidth, &_normalizedHeight);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionProp::OnDisconnect()
{
    if (_pointerPosition == NULL)
	{
        return E_UNEXPECTED;
    }

    _pointerPosition->Release();
    _pointerPosition = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionProp::OnApplyChanges()
{
	_pointerPosition->put_OutputMinimumPeriod(_outputMinimumPeriod);
	_pointerPosition->put_PointerShape(_pointerShape);
	_pointerPosition->put_PointerColor(_pointerColor);
	_pointerPosition->put_NormalizedOrigin(_normalizedOriginX, _normalizedOriginY);
	_pointerPosition->put_NormalizedSize(_normalizedWidth, _normalizedHeight);

    m_bDirty = FALSE;
    return(NOERROR);
}
//------------------------------------------------------------------------------
void
CPointerPositionProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[32];

	_stprintf(sz, "%d", _outputMinimumPeriod);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_OUTPUTMINPERIOD_EDIT), sz);

	HWND dlgItem = GetDlgItem(m_Dlg, IDC_POINTERSHAPE_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "W");
	ComboBox_AddString(dlgItem, "");
	ComboBox_AddString(dlgItem, "~");
	ComboBox_AddString(dlgItem, "lp");
	ComboBox_AddString(dlgItem, "Ə");
	ComboBox_AddString(dlgItem, "");
	if (IPointerPosition::NUM_POINTERSHAPE <= _pointerShape)
	{
		_stprintf(sz, "No. %d", _pointerShape);
		ComboBox_SetText(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_COMBO), sz);
	}
	else
	{
		ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_POINTERSHAPE_COMBO), (flInt)_pointerShape);
	}

	_stprintf(sz, "%d", _pointerColor[0]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORR_EDIT), sz);

	_stprintf(sz, "%d", _pointerColor[1]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORG_EDIT), sz);

	_stprintf(sz, "%d", _pointerColor[2]);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_POINTERCOLORB_EDIT), sz);

	_stprintf(sz, "%5.3f", _normalizedOriginX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_NORMORIGINOX_EDIT), sz);

	_stprintf(sz, "%5.3f", _normalizedOriginY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_NORMORIGINOY_EDIT), sz);

	_stprintf(sz, "%5.3f", _normalizedWidth);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_NORMSIZEOW_EDIT), sz);

	_stprintf(sz, "%5.3f", _normalizedHeight);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_NORMSIZEOH_EDIT), sz);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 50, NULL);
}
//------------------------------------------------------------------------------
void
CPointerPositionProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
