/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <streams.h>
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flTypes/flUIDs.h>
#include <flTypes/IPointerPosition.h>
#include <flPointerPosition/PointerPosition.h>
#include <flPointerPosition/PointerPositionStream.h>
#include <flFilterCommon/flPointerInfo.h>
#include <flBase/flNotify.h>
//------------------------------------------------------------------------------
#define TIMEOUT	2000
//------------------------------------------------------------------------------
CPointerPositionStream::CPointerPositionStream
					(HRESULT *phr, CPointerPosition *pParent, LPCWSTR pPinName) :
CSourceStream(NAME("PointerPositionStream"), phr, pParent, pPinName)
{
}
//------------------------------------------------------------------------------
CPointerPositionStream::~CPointerPositionStream()
{}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionStream::FillBuffer(IMediaSample *pms)
{
	CAutoLock autoLock(&_streamLock);

	CPointerPosition *pp = (CPointerPosition *)m_pFilter;
	flBool changed = false;

	while(pp->_isRunning && timeGetTime() - _syncTime < TIMEOUT && !changed)
	{
		// Sleep minimum period
		flULong outputMinimumPeriod;
		{
			CAutoLock autoLock(&pp->_filterLock);
			outputMinimumPeriod = pp->_outputMinimumPeriod;
		}
		Sleep(pp->_outputMinimumPeriod);

		// Update PointerInfo (Mouse position, button, etc..)
		changed = pp->updatePointerInfo();
	}


	// Setup Media sample
	BYTE *samplePtr;
	pms->GetPointer(&samplePtr);
	pms->SetTime(NULL, NULL);

	CAutoLock autoLock2(&pp->_filterLock);

	flByte *data;
	flUInt dataLength;

	if (!pp->_isRunning || TIMEOUT <= timeGetTime() - _syncTime)
	{
        pp->_pointerInfo.get(data, dataLength);
		pms->SetSyncPoint(TRUE);
		_syncTime = timeGetTime();
	}
	else
	{
		pp->_pointerInfo.getChanged(data, dataLength);
		pms->SetSyncPoint(FALSE);

		ASSERT(dataLength != 0);
	}

	pms->SetActualDataLength(dataLength);
	CopyMemory(samplePtr, data, dataLength);

	return NOERROR;
}
//------------------------------------------------------------------------------
// CSourceStream override
HRESULT
CPointerPositionStream::DecideBufferSize(IMemAllocator *pAlloc,
                            ALLOCATOR_PROPERTIES *pProp)
{
    CAutoLock cAutoLock(m_pFilter->pStateLock());
    ASSERT(pAlloc);
    ASSERT(pProp);
    HRESULT hr = NOERROR;

	pProp->cBuffers = 1;
	pProp->cbBuffer = PI_DEFAULTSAMPLESIZE;

    ASSERT(pProp->cbBuffer);

    ALLOCATOR_PROPERTIES Actual;
    hr = pAlloc->SetProperties(pProp,&Actual);
    if (FAILED(hr))
        return hr;

    if (Actual.cbBuffer < pProp->cbBuffer)
        return E_FAIL;

    ASSERT(Actual.cBuffers == 1);
    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionStream::SetMediaType(const CMediaType *pMediaType)
{
    CAutoLock cAutoLock(m_pFilter->pStateLock());
	
    // Pass the call up to my base class
    HRESULT hr = CSourceStream::SetMediaType(pMediaType);
	
	return hr;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionStream::GetMediaType(CMediaType *pmt)
{
	pmt->ResetFormatBuffer();
	
	pmt->SetType(&MEDIATYPE_Stream);
	pmt->SetSubtype(&MEDIASUBTYPE_PointerInfo);
	pmt->SetFormatType(&FORMAT_None);
	pmt->SetTemporalCompression(FALSE);
	pmt->SetVariableSize();

	return NOERROR;
}
//------------------------------------------------------------------------------
// Handler
HRESULT
CPointerPositionStream::OnThreadDestroy()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionStream::OnThreadCreate()
{
	CAutoLock autoLock(&_streamLock);
	_syncTime = timeGetTime();

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionStream::OnThreadStartPlay()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CPointerPositionStream::Notify(IBaseFilter * pSender, Quality q)
{
	flNotify::post(flNotify::L_INFO, "Notify() called.");
	return NOERROR;
}
//------------------------------------------------------------------------------
