/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerPositionStream_h__
#define __PointerPositionStream_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerPositionStream : public CSourceStream
{

public:
    CPointerPositionStream(HRESULT *phr, CPointerPosition *pParent, LPCWSTR pPinName);
    ~CPointerPositionStream();

public:
	// CSourceStream pure virtual
    HRESULT			FillBuffer(IMediaSample *pms);

	// CSourceStream override
    HRESULT			DecideBufferSize(IMemAllocator *pAlloc,
                             ALLOCATOR_PROPERTIES *pProp);

    HRESULT			SetMediaType(const CMediaType *pMediaType);
	HRESULT			GetMediaType(CMediaType *pmt);

	HRESULT			Run();

	// Handler
	HRESULT			OnThreadDestroy();
    HRESULT			OnThreadCreate();
	HRESULT			OnThreadStartPlay();

    STDMETHODIMP	Notify(IBaseFilter * pSender, Quality q);

protected:
    CCritSec		_streamLock;
	flLong			_syncTime;
};
//------------------------------------------------------------------------------
#endif //__PointerPositionStream_h__
