/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flPointerPosition/PointerPositionUserDataProp.h>
#include <flBase/flNotify.h>

#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CPointerPositionUserDataProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CPointerPositionUserDataProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CPointerPositionUserDataProp::CPointerPositionUserDataProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("PointerPositionUserDataProp"),pUnk,
                      IDD_POINTERPOSITIONUSERDATAPROP,
                      IDS_POINTERPOSITIONUSERDATAPROPTITLE),
    _pointerPosition(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CPointerPositionUserDataProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CPointerPositionUserDataProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
		case WM_INITDIALOG:
		{
			setupControls();
			return (LRESULT) 1;
		}
		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			case IDC_USERDATA_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[1024];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_USERDATA_EDIT), sz, 1024);
					sz[1023] = 0;

					_userDataSize = sizeof(TCHAR) * _tcslen(sz) + 1;
					if (PP_MAXIMUM_USERDATA_SIZE < _userDataSize)
						_userDataSize = PP_MAXIMUM_USERDATA_SIZE;
					memcpy(_userData, sz, _userDataSize);
					
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
		case WM_DESTROY:
		{
			shutdownControls();
			return (LRESULT) 1;
		}
	}
	return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionUserDataProp::OnConnect(IUnknown *pUnknown)
{
	ASSERT(_pointerPosition == NULL);

	HRESULT hr = pUnknown->QueryInterface(IID_IPointerPosition, (void **) &_pointerPosition);
	if (FAILED(hr))
	{
		return E_NOINTERFACE;
	}

	ASSERT(_pointerPosition);

	memset(_userData, 0, PP_MAXIMUM_USERDATA_SIZE);
	_pointerPosition->get_UserData(_userData, &_userDataSize);

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionUserDataProp::OnDisconnect()
{
    if (_pointerPosition == NULL)
	{
        return E_UNEXPECTED;
    }

    _pointerPosition->Release();
    _pointerPosition = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionUserDataProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CPointerPositionUserDataProp::OnApplyChanges()
{
	_pointerPosition->put_UserData(_userData, _userDataSize);

	m_bDirty = FALSE;
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CPointerPositionUserDataProp::setupControls()
{
	TCHAR sz[1024];

	memcpy(sz, _userData, PP_MAXIMUM_USERDATA_SIZE);
	sz[PP_MAXIMUM_USERDATA_SIZE] = 0;
	Edit_SetText(GetDlgItem(m_Dlg, IDC_USERDATA_EDIT), sz);

	_stprintf(sz, "[Uf[^ (ő%d)", PP_MAXIMUM_USERDATA_SIZE);
	Static_SetText(GetDlgItem(m_Dlg, IDC_USERDATA_GROUP), sz);
}
//------------------------------------------------------------------------------
void
CPointerPositionUserDataProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
