/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerPositionUserDataProp_h__
#define __PointerPositionUserDataProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IPointerPosition.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CPointerPositionUserDataProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CPointerPositionUserDataProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IPointerPosition*	_pointerPosition;

	flUInt				_userDataSize;
	flByte				_userData[PP_MAXIMUM_USERDATA_SIZE];
};
//------------------------------------------------------------------------------
#endif //__PointerPositionUserDataProp_h__
