/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __LocusData_h__
#define __LocusData_h__
//------------------------------------------------------------------------------
#include <flTypes/IPointerPosition.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#pragma pack(push, for_pack_1)
#pragma pack(1)
//------------------------------------------------------------------------------
struct flLocusData
{
public:
	flLocusData()
	{
		DrawButton			= 0x01;
		EraseButton			= 0x02;
		DrawPointerShape	= IPointerPosition::PPPS_STANDARD;
		memset(DrawPointerColor, 0xff, sizeof(DrawPointerColor));
		EdgingOn			= false;
		BrokenLineOn		= false;
		Width				= 1;
	}

public:
	flUShort	DrawButton;
	flUShort	EraseButton;
	flShort		DrawPointerShape;
	flByte		DrawPointerColor[3];
	flBool		EdgingOn;
	flBool		BrokenLineOn;
	flUShort	Width;
};
//------------------------------------------------------------------------------
#pragma pack(pop, for_pack_1)
//------------------------------------------------------------------------------
#endif //__LocusData_h__
