/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __StillPicture_h__
#define __StillPicture_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flSource.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IStillPicture.h>
#include <flBase/flImage.h>
#include <flBase/flImageIO.h>
#include <flBase/flString.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CStillPictureStream;
//------------------------------------------------------------------------------
class CStillPicture :
		public CFLSource,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IStillPicture
{
	friend class CStillPictureStream;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CStillPicture(TCHAR *tszName, LPUNKNOWN pUnk, HRESULT *phr);
    ~CStillPicture();

public:
	// Reveals IStillPicture & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
	// IMediaFilter
	STDMETHODIMP	Run(REFERENCE_TIME startTime);
	STDMETHODIMP	Pause();
	STDMETHODIMP	Stop();
	STDMETHODIMP	GetState(DWORD dwMSecs, FILTER_STATE *State);

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();

    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// IStillPicture
	STDMETHODIMP	get_OutputVideoResolution(flInt *videoResolution);
	STDMETHODIMP	put_OutputVideoResolution(flInt videoResolution);
	STDMETHODIMP	get_OutputMode(flInt* mode);
	STDMETHODIMP	put_OutputMode(flInt mode);
	STDMETHODIMP	get_Filename(flChar* filename);
	STDMETHODIMP	put_Filename(const flChar* filename);
	STDMETHODIMP	get_FrameRate(flInt *frameRate);
	STDMETHODIMP	put_FrameRate(flInt frameRate);
	STDMETHODIMP	get_NoiseOn(flBool *noiseOn);
	STDMETHODIMP	put_NoiseOn(flBool noiseOn);

private:
	void			setupImage();
	void			resize(flUInt width, flUInt height);
	void			resizeThrough();

protected:
	// Ciritcal Section for filter
	CCritSec				_filterLock;

	// Status
	flBool					_isRunning;
	flImage					_orgImage;
	flImage					_extImage;

	// Property
	flInt					_outVideoResolution;
	flInt					_outputMode;
	flString				_filename;
	flInt					_frameRate;
	flBool					_noiseOn;

protected:
	// Output Stream pin
	CStillPictureStream*	_stillPictureStream;
};
//------------------------------------------------------------------------------
#endif //__StillPicture_h__
