/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flStillPicture/StillPictureProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CStillPictureProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
	CUnknown *punk = new CStillPictureProp(lpunk, phr);
	if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
	}
	return punk;
}
//------------------------------------------------------------------------------
CStillPictureProp::CStillPictureProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("StillPictureProp"),pUnk,
                      IDD_STILLPICTUREPROP,
                      IDS_STILLPICTUREPROPTITLE),
    _stillPicture(NULL)
{
	InitCommonControls();
}
//------------------------------------------------------------------------------
void
CStillPictureProp::SetDirty()
{
	m_bDirty = TRUE;
	if (m_pPageSite)
	{
		m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
	}
}
//------------------------------------------------------------------------------
BOOL
CStillPictureProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_IMAGEFILE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_IMAGEFILE_EDIT),
											sz, SP_MAXIMUM_FILENAME_LENGTH);
					_imageFilename = flString(sz);
					SetDirty();
				}
				break;
			case IDC_OUTPUTRESOLUTION_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_outVideoResolution = ComboBox_GetCurSel(
									GetDlgItem(m_Dlg, IDC_OUTPUTRESOLUTION_COMBO));
					SetDirty();
				}
				break;
			case IDC_OUTPUTMODE_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_outputMode = ComboBox_GetCurSel(
									GetDlgItem(m_Dlg, IDC_OUTPUTMODE_COMBO));
					SetDirty();
				}
				break;
			case IDC_FRAMERATE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT),
													sz, STR_MAX_LENGTH);
					_frameRate = (flInt)atof(sz);
					SetDirty();
				}
				break;
			case IDC_IMAGEFILEREF_BUTTON:
				{
					flChar name[MAX_PATH];
					memset(name, 0, MAX_PATH);

					OPENFILENAME ofn;
					memset(&ofn, 0, sizeof(OPENFILENAME));
					ofn.lStructSize		= sizeof(OPENFILENAME);
					ofn.hwndOwner		= m_Dlg;
					ofn.hInstance		= (HINSTANCE)GetModuleHandle(NULL);
					ofn.lpstrFilter		= "Image File\0*.bmp;*.png;*.jpg\0\0";
					ofn.lpstrFile		= name;
					ofn.nMaxFile		= MAX_PATH;
					ofn.lpstrTitle		= NULL;
					ofn.lpstrInitialDir	= NULL;
					ofn.Flags			= OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

					if (GetOpenFileName(&ofn))
					{
						Edit_SetText(GetDlgItem(m_Dlg, IDC_IMAGEFILE_EDIT),
											name);
					}
				}
				break;
			case IDC_NOISEON_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, IDC_NOISEON_CHECK));
					_noiseOn = (checked ? true : false);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CStillPictureProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_stillPicture == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IStillPicture, (void **) &_stillPicture);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_stillPicture);

	flChar str[SP_MAXIMUM_FILENAME_LENGTH];
	_stillPicture->get_Filename(str);
	_imageFilename = flString(str);
	_stillPicture->get_OutputVideoResolution(&_outVideoResolution);
	_stillPicture->get_OutputMode(&_outputMode);
	_stillPicture->get_FrameRate(&_frameRate);
	_stillPicture->get_NoiseOn(&_noiseOn);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CStillPictureProp::OnDisconnect()
{
    if (_stillPicture == NULL)
	{
        return E_UNEXPECTED;
    }

    _stillPicture->Release();
    _stillPicture = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CStillPictureProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CStillPictureProp::OnApplyChanges()
{
	_stillPicture->put_Filename(_imageFilename.c_str());
	_stillPicture->put_OutputVideoResolution(_outVideoResolution);
	_stillPicture->put_OutputMode(_outputMode);
	_stillPicture->put_FrameRate(_frameRate);
	_stillPicture->put_NoiseOn(_noiseOn);

	m_bDirty = FALSE;
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CStillPictureProp::setupControls()
{
	TCHAR   sz[32];

	// Filename
	Edit_SetText(GetDlgItem(m_Dlg, IDC_IMAGEFILE_EDIT), _imageFilename.c_str());

	// OutputResolution
	HWND combo = GetDlgItem(m_Dlg, IDC_OUTPUTRESOLUTION_COMBO);
	ComboBox_ResetContent(combo);
	ComboBox_AddString(combo, _T("SQCIF"));
	ComboBox_AddString(combo, _T("QCIF"));
	ComboBox_AddString(combo, _T("CIF"));
	ComboBox_AddString(combo, _T("160x120"));
	ComboBox_AddString(combo, _T("320x240"));
	ComboBox_AddString(combo, _T("360x240"));
	ComboBox_AddString(combo, _T("640x480"));
	ComboBox_AddString(combo, _T("720x480"));
	ComboBox_AddString(combo, _T("800x600"));
	ComboBox_AddString(combo, _T("1024x768"));
	ComboBox_AddString(combo, _T("1280x1024"));
	ComboBox_AddString(combo, _T("1600x1200"));
	ComboBox_AddString(combo, _T("HDTV 720p"));
	ComboBox_AddString(combo, _T("HDTV 1080i"));
	ComboBox_AddString(combo, _T("SDTV 480p"));
	ComboBox_AddString(combo, _T("SDTV 480i"));
	ComboBox_AddString(combo, _T("摜TCYƓ"));
	ComboBox_SetCurSel(combo, _outVideoResolution);

	// OutputMode
	combo = GetDlgItem(m_Dlg, IDC_OUTPUTMODE_COMBO);
	ComboBox_ResetContent(combo);
	ComboBox_AddString(combo, _T("o͉𑜓xɍ킹"));
	ComboBox_AddString(combo, _T("cŒŏo͉𑜓x̍ɍ킹"));
	ComboBox_AddString(combo, _T("cŒŏo͉𑜓x̕ɍ킹"));
	ComboBox_AddString(combo, _T("cŒŃC[WŜ悤ɂ"));
	ComboBox_SetCurSel(combo, _outputMode);

	// Frame Rate
	_stprintf(sz, "%d", _frameRate);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz);

	// Noise
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_NOISEON_CHECK), (_noiseOn ? TRUE : FALSE));
}
//------------------------------------------------------------------------------
void
CStillPictureProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
