/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __StillPictureStream_h__
#define __StillPictureStream_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flSourceStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CStillPicture;
//------------------------------------------------------------------------------
class CStillPictureStream : public CFLSourceStream
{

public:
    CStillPictureStream(HRESULT *phr, CStillPicture *pParent, LPCWSTR pPinName);
    ~CStillPictureStream();

public:
    HRESULT			FillBuffer(IMediaSample *pms);
	void			AdjustRate(flInt64 deliverProcTime);

    HRESULT			DecideBufferSize(IMemAllocator *pIMemAlloc,
                             ALLOCATOR_PROPERTIES *pProperties);

    HRESULT			SetMediaType(const CMediaType *pmt);
	HRESULT			GetMediaType(CMediaType *pmt);

	HRESULT			OnThreadCreate();

    STDMETHODIMP	Notify(IBaseFilter * pSender, Quality q);

protected:
	CStillPicture*	_stillPicture;
	REFERENCE_TIME	_streamTime;
};
//------------------------------------------------------------------------------
#endif //__StillPictureStream_h__
