/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IDIGITALCLOCK_H__
#define __IDIGITALCLOCK_H__
//------------------------------------------------------------------------------
#define DC_MAXIMUM_HEADERFOOTER_LENGTH 512
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {FEC6478F-F93E-432e-A4F9-B7C7D284B862}
	DEFINE_GUID(IID_IDigitalClock, 
	0xfec6478f, 0xf93e, 0x432e, 0xa4, 0xf9, 0xb7, 0xc7, 0xd2, 0x84, 0xb8, 0x62);

    DECLARE_INTERFACE_(IDigitalClock, IUnknown)
    {
		enum VideoResolutionEnum {
			DCVR_SQCIF,
			DCVR_QCIF,
			DCVR_CIF,
			DCVR_160x120,
			DCVR_320x240,
			DCVR_360x240,
			DCVR_640x480,
			DCVR_720x480,
			DCVR_800x600,
			DCVR_1024x768,
			DCVR_1280x1024,
			DCVR_1600x1200,
			DCVR_HDTV720P,
			DCVR_HDTV1080I,
			DCVR_SDTV480P,
			DCVR_SDTV480I,
			NUM_DCVR
		};

		STDMETHOD(get_OutputVideoResolution) (
			THIS_ int *videoResolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (
			THIS_ int videoResolution
		) PURE;

		STDMETHOD(get_FrameRate) (
			THIS_ int *frameRate
		) PURE;

		STDMETHOD(put_FrameRate) (
			THIS_ int frameRate
		) PURE;

		enum FontSizeEnum
		{
			DCFS_8PT,
			DCFS_12PT,
			DCFS_16PT,
			DCFS_20PT,
			DCFS_24PT,
			DCFS_28PT,
			DCFS_36PT,
			DCFS_44PT,
			DCFS_60PT,
			DCFS_76PT,
			DCFS_100PT,
			DCFS_124PT,
			DCFS_AUTO
		};

		STDMETHOD(get_FontSize) (
			THIS_ int* fontSize
		) PURE;

		STDMETHOD(put_FontSize) (
			THIS_ int fontSize
		) PURE;

		STDMETHOD(get_FontColor) (
			THIS_ unsigned char *color
		) PURE;

		STDMETHOD(put_FontColor) (
			THIS_ const unsigned char *color
		) PURE;

		STDMETHOD(get_BackgroundColor) (
			THIS_ unsigned char *color
		) PURE;

		STDMETHOD(put_BackgroundColor) (
			THIS_ const unsigned char *color
		) PURE;

		STDMETHOD(get_HeaderString) (
			THIS_ char *string
		) PURE;

		STDMETHOD(put_HeaderString) (
			THIS_ const char *string
		) PURE;

		STDMETHOD(get_FooterString) (
			THIS_ char *string
		) PURE;

		STDMETHOD(put_FooterString) (
			THIS_ const char *string
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IDIGITALCLOCK_H__
