/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IDRAWCAPTION_H__
#define __IDRAWCAPTION_H__
//------------------------------------------------------------------------------
#define DC_MAXIMUM_CAPTION_LENGTH		128
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {18C7B6AE-FD76-4a3c-8032-4AD09B4E1441}
	DEFINE_GUID(IID_IDrawCaption, 
	0x18c7b6ae, 0xfd76, 0x4a3c, 0x80, 0x32, 0x4a, 0xd0, 0x9b, 0x4e, 0x14, 0x41);

    DECLARE_INTERFACE_(IDrawCaption, IUnknown)
    {
		// Caption On
		STDMETHOD(get_CaptionOn) (
			THIS_ bool *captionOn
		) PURE;

		STDMETHOD(put_CaptionOn) (
			THIS_ bool captionOn
		) PURE;

		// Caption
		STDMETHOD(get_Caption) (
			THIS_ char *caption
		) PURE;

		STDMETHOD(put_Caption) (
			THIS_ const char* caption
		) PURE;

		// Font Size
		STDMETHOD(get_FontSize) (
			THIS_ unsigned int *fontSize
		) PURE;

		STDMETHOD(put_FontSize) (
			THIS_ unsigned int fontSize
		) PURE;

	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IDRAWCAPTION_H__
