/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IDRAWFRAME_H__
#define __IDRAWFRAME_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {196C9C38-9A29-4133-8E12-05217D1ED744}
	DEFINE_GUID(IID_IDrawFrame, 
	0x196c9c38, 0x9a29, 0x4133, 0x8e, 0x12, 0x5, 0x21, 0x7d, 0x1e, 0xd7, 0x44);

    DECLARE_INTERFACE_(IDrawFrame, IUnknown)
    {
		// Frame On
		STDMETHOD(get_FrameOn) (
			THIS_ bool *frameOn
		) PURE;

		STDMETHOD(put_FrameOn) (
			THIS_ bool frameOn
		) PURE;

		// Frame Type
		enum FrameTypeEnum {
			DFFT_RECTANGLE = 0,
			DFFT_OVAL,
			NUM_DFFT
		};
		STDMETHOD(get_FrameType) (
			THIS_ int *frameType
		) PURE;

		STDMETHOD(put_FrameType) (
			THIS_ int frameType
		) PURE;

		// PointerIn Disable
		STDMETHOD(get_PointerInDisable) (
			THIS_ bool* flag
		) PURE;

		STDMETHOD(put_PointerInDisable) (
			THIS_ bool flag
		) PURE;

		// Frame Position
		STDMETHOD(get_Position) (
			THIS_ int* x, THIS_ int* y
		) PURE;

		STDMETHOD(put_Position) (
			THIS_ int x, THIS_ int y
		) PURE;

		// Frame Size
		STDMETHOD(get_Size) (
			THIS_ unsigned int* width, THIS_ unsigned int* height
		) PURE;

		STDMETHOD(put_Size) (
			THIS_ unsigned int width, THIS_ unsigned int height
		) PURE;

		// Frame Color
		STDMETHOD(get_Color) (
			THIS_ unsigned char* r, THIS_ unsigned char* g, THIS_ unsigned char* b
		) PURE;

		STDMETHOD(put_Color) (
			THIS_ unsigned char r, THIS_ unsigned char g, THIS_ unsigned char b
		) PURE;

		// Frame Thickness
		STDMETHOD(get_Thickness) (
			THIS_ unsigned int* thickness
		) PURE;

		STDMETHOD(put_Thickness) (
			THIS_ unsigned int thickness
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IDRAWFRAME_H__
