/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __IFORMATTRANS_H__
#define __IFORMATTRANS_H__

#ifdef __cplusplus
extern "C" {
#endif

	// {4073C6BC-9BFD-4a07-A1CE-A81147CEC8F4}
	DEFINE_GUID(IID_IFormatTrans, 
	0x4073c6bc, 0x9bfd, 0x4a07, 0xa1, 0xce, 0xa8, 0x11, 0x47, 0xce, 0xc8, 0xf4);

    DECLARE_INTERFACE_(IFormatTrans, IUnknown)
    {
		enum VideoResolutionEnum {
			VR_SQCIF,
			VR_QCIF,
			VR_CIF,
			VR_160x120,
			VR_320x240,
			VR_360x240,
			VR_640x480,
			VR_720x480,
			VR_800x600,
			VR_1024x768,
			VR_1280x1024,
			VR_1600x1200,
			VR_HDTV720P,
			VR_HDTV1080I,
			VR_SDTV480P,
			VR_SDTV480I,
			VR_AUTO,
			VR_THROUGH = VR_AUTO,
			VR_UNRECOGNIZED = VR_AUTO,
			NUM_VR
		};

		enum VideoColorEnum {
			VC_RGB8,
			VC_RGB555,
			VC_RGB565,
			VC_RGB24,
			VC_AUTO,
			VC_THROUGH = VC_AUTO,
			VC_UNRECOGNIZED = VC_AUTO,
			NUM_VC
		};

		STDMETHOD(get_InputVideoResolution) (THIS_
			unsigned int *videoResolution
		) PURE;

		STDMETHOD(put_InputVideoResolution) (THIS_
			unsigned int videoResolution
		) PURE;

		STDMETHOD(put_DefaultInputVideoResolution) (THIS) PURE;

		STDMETHOD(get_InputVideoColor) (THIS_
			unsigned int *videoColor
		) PURE;

		STDMETHOD(put_InputVideoColor) (THIS_
			unsigned int videoColor
		) PURE;

		STDMETHOD(put_DefaultInputVideoColor) (THIS) PURE;

		STDMETHOD(get_OutputVideoResolution) (THIS_
			unsigned int *videoResolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (THIS_
			unsigned int videoResolution
		) PURE;

		STDMETHOD(put_DefaultOutputVideoResolution) (THIS) PURE;

		// Monitor
		STDMETHOD(get_ActualInputVideoResolution) (
			THIS_ unsigned int *videoResolution) PURE;
		
		STDMETHOD(get_ActualInputVideoColor) (
			THIS_ unsigned int *videoColor) PURE;

		STDMETHOD(get_ActualOutputVideoResolution) (
			THIS_ unsigned int *videoResolution) PURE;
	};

#ifdef __cplusplus
}
#endif

#endif // __IFORMATTRANS_H__

