/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ILEVELCOMPRESS_H__
#define __ILEVELCOMPRESS_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {AD369913-FA7B-4c18-8EA2-A7C934A11C04}
	DEFINE_GUID(IID_ILevelCompress, 
	0xad369913, 0xfa7b, 0x4c18, 0x8e, 0xa2, 0xa7, 0xc9, 0x34, 0xa1, 0x1c, 0x4);

    DECLARE_INTERFACE_(ILevelCompress, IUnknown)
    {
		STDMETHOD(get_Flip) (
			THIS_ bool* flip
		) PURE;

		STDMETHOD(put_Flip) (
			THIS_ bool flip
		) PURE;

		enum VideoColorEnum {
			LCVC_RGB555,
			LCVC_RGB24,
			LCVC_AUTO,
			NUM_LCVC
		};

		STDMETHOD(get_InputVideoColor) (
			THIS_ int* color
		) PURE;

		STDMETHOD(put_InputVideoColor) (
			THIS_ int color
		) PURE;

		STDMETHOD(get_FrameRate) (
			THIS_ int* rate
		) PURE;

		STDMETHOD(put_FrameRate) (
			THIS_ int rate
		) PURE;

		enum BufferModeEnum {
			LCBM_GDI,
			LCBM_MEMORY,
			NUM_LCBM
		};

		STDMETHOD(get_BufferMode) (
			THIS_ int* mode
		) PURE;

		STDMETHOD(put_BufferMode) (
			THIS_ int mode
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ILEVELCOMPRESS_H__
