/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IMULTICASTRECEIVER_H__
#define __IMULTICASTRECEIVER_H__
//------------------------------------------------------------------------------
#define MR_MAXIMUM_USERDATA_SIZE		64
#define MR_MAXIMUM_MEDIATYPESTR_LENGTH	1024
#define MR_MAXIMUM_ADDRESS_LENGTH		1024
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {6113A5E7-D566-4dd6-8A1F-CBE55991A77F}
	DEFINE_GUID(IID_IMulticastReceiver, 
	0x6113a5e7, 0xd566, 0x4dd6, 0x8a, 0x1f, 0xcb, 0xe5, 0x59, 0x91, 0xa7, 0x7f);

    DECLARE_INTERFACE_(IMulticastReceiver, IUnknown)
    {
		// Monitor Functions
		STDMETHOD(is_SocketOpen) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(is_Streaming) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(is_OutputMediaTypeAgreement) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(get_AbsoluteTime) (THIS_
			__int64 *absTime
		) PURE;

		STDMETHOD(get_ReceiveRate) (THIS_
			unsigned int *rate
		) PURE;

		STDMETHOD(get_FrameRate) (THIS_
			unsigned int *rate
		) PURE;

		STDMETHOD(get_PacketSize) (THIS_
			unsigned int *byte
		) PURE;

		STDMETHOD(get_NumTotalPackets) (THIS_
			unsigned int *numPackets
		) PURE;

		STDMETHOD(get_NumTotalFrames) (THIS_
			unsigned int *numFrames
		) PURE;

		STDMETHOD(get_NumDropPackets) (THIS_
			unsigned int *numPackets
		) PURE;

		STDMETHOD(get_NumDropFrames) (THIS_
			unsigned int *numFrames
		) PURE;

		STDMETHOD(get_NumOverwriteFrames) (THIS_
			unsigned int *numFrames
		) PURE;

		STDMETHOD(get_UserData) (THIS_
			unsigned char *userData,
			unsigned int* size
		) PURE;

		STDMETHOD(get_MediaTypeString) (THIS_
			char *str
		) PURE;

		STDMETHOD(get_SenderAddress) (THIS_
			char *address
		) PURE;

		// Address
		STDMETHOD(get_Address) (THIS_
			char *address
		) PURE;

		STDMETHOD(put_Address) (THIS_
			const char *address
		) PURE;

		// Port
		STDMETHOD(get_Port) (THIS_
			unsigned short *port
		) PURE;

		STDMETHOD(put_Port) (THIS_
			unsigned short port
		) PURE;

		// TTL
		STDMETHOD(get_TimeToLive) (THIS_
			unsigned long *ttl
		) PURE;

		STDMETHOD(put_TimeToLive) (THIS_
			unsigned long ttl
		) PURE;

		// Rejection Address
		STDMETHOD(get_NumRejectionAddress) (THIS_
			unsigned int *num
		) PURE;

		STDMETHOD(get_RejectionAddress) (THIS_
			unsigned int index, char *address
		) PURE;

		STDMETHOD(add_RejectionAddress) (THIS_
			const char *address
		) PURE;

		STDMETHOD(remove_RejectionAddress) (THIS_
			unsigned int index
		) PURE;

		STDMETHOD(remove_AllRejectionAddress) (
		) PURE;

		// Media Type
		enum MediaTypeEnum {
			MRMT_VIDEO = 0,
			MRMT_AUDIO,
			MRMT_POINTER,
			MRMT_UNKNOWN,
			NUM_MRMT
		};
		STDMETHOD(get_MediaType) (THIS_
			int *type
		) PURE;

		STDMETHOD(put_MediaType) (THIS_
			int type
		) PURE;

		// Video Format
		enum VideoFormatEnum {
			MRVF_RGB555 = 0,
			MRVF_RGB24,
			MRVF_MPEG4_2,
			MRVF_MPEG4_3,
			MRVF_DVSD,
			MRVF_H261,
			MRVF_H263,
			MRVF_MJPEG,
			MRVF_UNKNOWN,
			NUM_MRVF
		};
		STDMETHOD(get_VideoFormat) (THIS_
			int *videoFormat
		) PURE;

		STDMETHOD(put_VideoFormat) (THIS_
			int videoFormat
		) PURE;

		// Video Resolution
		enum VideoResolutionEnum {
			MRVR_SQCIF = 0,
			MRVR_QCIF,
			MRVR_CIF,
			MRVR_160x120,
			MRVR_180x120,
			MRVR_320x240,
			MRVR_360x240,
			MRVR_640x480,
			MRVR_720x480,
			MRVR_800x600,
			MRVR_1024x768,
			MRVR_1280x1024,
			MRVR_1600x1200,
			MRVR_HDTV720P,
			MRVR_HDTV1080I,
			MRVR_SDTV480P,
			MRVR_SDTV480I,
			MRVR_UNKNOWN,
			NUM_MRVR
		};
		STDMETHOD(get_VideoResolution) (THIS_
			int *videoResolution
		) PURE;

		STDMETHOD(put_VideoResolution) (THIS_
			int videoResolution
		) PURE;

		// Audio Format
		enum AudioFormatEnum {
			MRAF_MP3 = 0,
			MRAF_PCM,
			MRAF_MPEG1,
			MRAF_UNKNOWN,
			NUM_MRAF
		};
		STDMETHOD(get_AudioFormat) (THIS_
			int *audioFormat
		) PURE;

		STDMETHOD(put_AudioFormat) (THIS_
			int audioFormat
		) PURE;

		// Audio Frequency
		enum AudioFrequencyEnum {
			MRAQ_8KHz = 0,
			MRAQ_11KHz,
			MRAQ_16KHz,
			MRAQ_22KHz,
			MRAQ_44_1KHz,
			MRAQ_48KHz,
			MRAQ_UNKNOWN,
			NUM_MRAQ
		};
		STDMETHOD(get_AudioFrequency) (THIS_
			int *audioFrequency
		) PURE;

		STDMETHOD(put_AudioFrequency) (THIS_
			int audioFrequency
		) PURE;

		// Audio Stereo
		enum AudioStereoEnum {
			MRAS_STEREO = 0,
			MRAS_MONO,
			MRAS_UNKNOWN,
			NUM_MRAS
		};
		STDMETHOD(get_AudioStereo) (THIS_
			int *audioStereo
		) PURE;

		STDMETHOD(put_AudioStereo) (THIS_
			int audioStereo
		) PURE;

		// Audio Bit count
		enum AudioBitCountEnum {
			MRAB_0Bit = 0,
			MRAB_8Bit,
			MRAB_16Bit,
			MRAB_UNKNOWN,
			NUM_MRAB
		};
		STDMETHOD(get_AudioBitCount) (THIS_
			int *audioBitCount
		) PURE;

		STDMETHOD(put_AudioBitCount) (THIS_
			int audioBitCount
		) PURE;

		// Auto Config Output media type
		STDMETHOD(get_EnableConnectReceiveMediaType) (THIS_
			bool *enable
		) PURE;

		STDMETHOD(put_EnableConnectReceiveMediaType) (THIS_
			bool enable
		) PURE;

		// Reset Time Stamp
		enum TimeStampModeEnum {
			MRTM_INVALIDATE,
			MRTM_USESTREAMTIME,
			MRTM_USEABSOLUTETIME,
		};

		STDMETHOD(get_TimeStampMode) (THIS_
			int *mode
		) PURE;

		STDMETHOD(put_TimeStampMode) (THIS_
			int mode
		) PURE;

		// Video Image Normalized Position
		STDMETHOD(get_VideoImageNormalizedPosition) (THIS_
			float *x, float *y
		) PURE;

		STDMETHOD(put_VideoImageNormalizedPosition) (THIS_
			float x, float y
		) PURE;

		// Video Image Normalized Size
		STDMETHOD(get_VideoImageNormalizedSize) (THIS_
			float *width, float *height
		) PURE;

		STDMETHOD(put_VideoImageNormalizedSize) (THIS_
			float width, float height
		) PURE;
    };

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IMULTICASTRECEIVER_H__
