/*
**	Copyright (c) 2003 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IMULTICASTSENDER_H__
#define __IMULTICASTSENDER_H__
//------------------------------------------------------------------------------
#define MS_MAXIMUM_USERDATA_SIZE		64
#define MS_MAXIMUM_ADDRESS_LENGTH		1024
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {A03D4F80-2A7F-4388-B061-7906DB1CE83B}
	DEFINE_GUID(IID_IMulticastSender, 
	0xa03d4f80, 0x2a7f, 0x4388, 0xb0, 0x61, 0x79, 0x6, 0xdb, 0x1c, 0xe8, 0x3b);

    DECLARE_INTERFACE_(IMulticastSender, IUnknown)
    {
		// Monitor Functions
		STDMETHOD(is_SocketOpen) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(get_AbsoluteTime) (THIS_
			__int64 *absoluteTime
		) PURE;

		STDMETHOD(get_TransmissionRate) (THIS_
			unsigned int *rate
		) PURE;

		STDMETHOD(get_FrameRate) (THIS_
			unsigned int *rate
		) PURE;

		STDMETHOD(get_NumTotalPackets) (THIS_
			unsigned int *numPackets
		) PURE;

		STDMETHOD(get_NumTotalFrames) (THIS_
			unsigned int *numFrames
		) PURE;

		// Media Type
		enum MediaTypeEnum {
			MSMT_VIDEO = 0,
			MSMT_AUDIO,
			MSMT_POINTER,
			MSMT_UNKNOWN,
			MSMT_ALL = MSMT_UNKNOWN,
			NUM_MSMT
		};
		STDMETHOD(get_MediaType) (THIS_
			int *type
		) PURE;

		STDMETHOD(put_MediaType) (THIS_
			int type
		) PURE;

		STDMETHOD(get_InputMediaType) (THIS_
			int *type
		) PURE;

		enum VideoFormatEnum {
			MSVF_RGB555 = 0,
			MSVF_RGB24,
			MSVF_MPEG4_2,
			MSVF_MPEG4_3,
			MSVF_DVSD,
			MSVF_H261,
			MSVF_H263,
			MSVF_MJPEG,
			MSVF_UNKNOWN,
			MSVF_ALL = MSVF_UNKNOWN,
			NUM_MSVF
		};
		STDMETHOD(get_VideoFormat) (THIS_
			int *videoFormat
		) PURE;

		STDMETHOD(put_VideoFormat) (THIS_
			int videoFormat
		) PURE;

		STDMETHOD(get_InputVideoFormat) (THIS_
			int *videoFormat
		) PURE;

		enum VideoResolutionEnum {
			MSVR_SQCIF = 0,
			MSVR_QCIF,
			MSVR_CIF,
			MSVR_160x120,
			MSVR_180x120,
			MSVR_320x240,
			MSVR_360x240,
			MSVR_640x480,
			MSVR_720x480,
			MSVR_800x600,
			MSVR_1024x768,
			MSVR_1280x1024,
			MSVR_1600x1200,
			MSVR_HDTV720P,
			MSVR_HDTV1080I,
			MSVR_SDTV480P,
			MSVR_SDTV480I,
			MSVR_UNKNOWN,
			MSVR_ALL = MSVR_UNKNOWN,
			NUM_MSVR
		};
		STDMETHOD(get_VideoResolution) (THIS_
			int *videoResolution
		) PURE;

		STDMETHOD(put_VideoResolution) (THIS_
			int videoResolution
		) PURE;

		STDMETHOD(get_InputVideoResolution) (THIS_
			int *videoResolution
		) PURE;

		enum AudioFormatEnum {
			MSAF_MP3 = 0,
			MSAF_PCM,
			MSAF_MPEG1,
			MSAF_UNKNOWN,
			MSAF_ALL = MSAF_UNKNOWN,
			NUM_MSAF
		};
		STDMETHOD(get_AudioFormat) (THIS_
			int *audioFormat
		) PURE;

		STDMETHOD(put_AudioFormat) (THIS_
			int audioFormat
		) PURE;

		STDMETHOD(get_InputAudioFormat) (THIS_
			int *audioFormat
		) PURE;

		enum AudioFrequencyEnum {
			MSAQ_8KHz = 0,
			MSAQ_11KHz,
			MSAQ_16KHz,
			MSAQ_22KHz,
			MSAQ_44_1KHz,
			MSAQ_48KHz,
			MSAQ_UNKNOWN,
			MSAQ_ALL = MSAQ_UNKNOWN,
			NUM_MSAQ
		};
		STDMETHOD(get_AudioFrequency) (THIS_
			int *audioFrequency
		) PURE;

		STDMETHOD(put_AudioFrequency) (THIS_
			int audioFrequency
		) PURE;

		STDMETHOD(get_InputAudioFrequency) (THIS_
			int *audioFrequency
		) PURE;

		enum AudioStereoEnum {
			MSAS_STEREO = 0,
			MSAS_MONO,
			MSAS_UNKNOWN,
			MSAS_ALL = MSAS_UNKNOWN,
			NUM_MSAS
		};
		STDMETHOD(get_AudioStereo) (THIS_
			int *audioStereo
		) PURE;

		STDMETHOD(put_AudioStereo) (THIS_
			int audioStereo
		) PURE;

		STDMETHOD(get_InputAudioStereo) (THIS_
			int *audioStereo
		) PURE;

		enum AudioBitCountEnum {
			MSAB_0Bit = 0,
			MSAB_8Bit,
			MSAB_16Bit,
			MSAB_UNKNOWN,
			MSAB_ALL = MSAB_UNKNOWN,
			NUM_MSAB
		};
		STDMETHOD(get_AudioBitCount) (THIS_
			int *audioBitCount
		) PURE;

		STDMETHOD(put_AudioBitCount) (THIS_
			int audioBitCount
		) PURE;

		STDMETHOD(get_InputAudioBitCount) (THIS_
			int *audioBitCount
		) PURE;

		// Address
		STDMETHOD(get_Address) (THIS_
			char *address
		) PURE;

		STDMETHOD(put_Address) (THIS_
			const char *address
		) PURE;

		// Port
		STDMETHOD(get_Port) (THIS_
			unsigned short *port
		) PURE;

		STDMETHOD(put_Port) (THIS_
			unsigned short port
		) PURE;

		// TTL
		STDMETHOD(get_TimeToLive) (THIS_
			unsigned long *ttl
		) PURE;

		STDMETHOD(put_TimeToLive) (THIS_
			unsigned long ttl
		) PURE;

		// Enable Transmission
		STDMETHOD(get_EnableTransmit) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(put_EnableTransmit) (THIS_
			bool flag
		) PURE;

		// Transmission Count
		STDMETHOD(get_TransmissionCount) (THIS_
			unsigned int *count
		) PURE;

		STDMETHOD(put_TransmissionCount) (THIS_
			unsigned int count
		) PURE;

		// Maximum Transmission Rate
		STDMETHOD(get_MaximumTransmissionRate) (THIS_
			unsigned int *maximumTransmissionRate
		) PURE;

		STDMETHOD(put_MaximumTransmissionRate) (THIS_
			unsigned int maximumTransmissionRate
		) PURE;

		// System Buffer Size
		STDMETHOD(get_SystemBufferSize) (THIS_
			unsigned int *bit
		) PURE;

		STDMETHOD(put_SystemBufferSize) (THIS_
			unsigned int bit
		) PURE;

		// Clock Minimum period
		STDMETHOD(get_ClockMinimumPeriod) (THIS_
			float *millisecond
		) PURE;

		STDMETHOD(put_ClockMinimumPeriod) (THIS_
			float millisecond
		) PURE;

		STDMETHOD(compute_ClockMinimumPeriod) (THIS_
			) PURE;

		// Maximum Packet size
		STDMETHOD(get_MaximumPacketSize) (THIS_
			unsigned int *byte
		) PURE;

		STDMETHOD(put_MaximumPacketSize) (THIS_
			unsigned int byte
		) PURE;

		// User Data
		STDMETHOD(get_UserData) (THIS_
			unsigned char *userData, unsigned int* size
		) PURE;

		STDMETHOD(put_UserData) (THIS_
			const unsigned char *userData, unsigned int size
		) PURE;

    };

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IMULTICASTSENDER_H__
