/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __INONLINEARZOOM_H__
#define __INONLINEARZOOM_H__

#ifdef __cplusplus
extern "C" {
#endif

	// {C83D778A-713B-4e0d-8F35-E7B2FADFC519}
	DEFINE_GUID(IID_INonLinearZoom, 
	0xc83d778a, 0x713b, 0x4e0d, 0x8f, 0x35, 0xe7, 0xb2, 0xfa, 0xdf, 0xc5, 0x19);

    DECLARE_INTERFACE_(INonLinearZoom, IUnknown)
    {
		enum VideoResolutionEnum {
			VR_SQCIF,
			VR_QCIF,
			VR_CIF,
			VR_160x120,
			VR_320x240,
			VR_360x240,
			VR_640x480,
			VR_720x480,
			VR_800x600,
			VR_1024x768,
			VR_1280x1024,
			VR_1600x1200,
			VR_HDTV720P,
			VR_HDTV1080I,
			VR_SDTV480P,
			VR_SDTV480I,
			NUM_VR
		};
		STDMETHOD(get_OutputVideoResolution) (THIS_
			unsigned int *videoResolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (THIS_
			unsigned int videoResolution
		) PURE;

		enum MaskEnum {
			M_RECTANGLE,
			M_ELLIPSE,
			NUM_M
		};
		STDMETHOD(get_Mask) (THIS_
			unsigned int *mask
		) PURE;

		STDMETHOD(put_Mask) (THIS_
			unsigned int mask
		) PURE;

		STDMETHOD(get_MaskPosition) (THIS_
			int *x, int *y
		) PURE;

		STDMETHOD(put_MaskPosition) (THIS_
			int x, int y
		) PURE;

		STDMETHOD(get_MaskSize) (THIS_
			int *w, int *h
		) PURE;

		STDMETHOD(put_MaskSize) (THIS_
			int w, int h
		) PURE;

		STDMETHOD(get_PointerInDisable) (THIS_
			bool* flag
		) PURE;

		STDMETHOD(put_PointerInDisable) (THIS_
			bool flag
		) PURE;

	};

#ifdef __cplusplus
}
#endif

#endif //__INONLINEARZOOM_H__

