/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IPOINTERMIXER_H__
#define __IPOINTERMIXER_H__
//------------------------------------------------------------------------------
#define PM_MAXIMUM_POINTERSHAPEWIDTH		256
#define PM_MAXIMUM_POINTERSHAPEHEIGHT		256
#define PM_MAXIMUM_POINTERSHAPENAME_LENGTH	512
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {F8DD203D-089A-4ab9-BEBB-ABEDAB87F2BC}
	DEFINE_GUID(IID_IPointerMixer, 
	0xf8dd203d, 0x89a, 0x4ab9, 0xbe, 0xbb, 0xab, 0xed, 0xab, 0x87, 0xf2, 0xbc);

    DECLARE_INTERFACE_(IPointerMixer, IUnknown)
    {
		// Basic Properties
		STDMETHOD(get_WindowPosition) (
			THIS_ float *x, THIS_ float *y) PURE;

		STDMETHOD(put_WindowPosition) (
			THIS_ float x, THIS_ float y) PURE;

		STDMETHOD(get_WindowSize) (
			THIS_ float *width, THIS_ float *height) PURE;

		STDMETHOD(put_WindowSize) (
			THIS_ float width, THIS_ float height) PURE;

		STDMETHOD(get_MappingPosition) (
			THIS_ float *x, THIS_ float *y) PURE;

		STDMETHOD(put_MappingPosition) (
			THIS_ float x, THIS_ float y) PURE;

		STDMETHOD(get_MappingSize) (
			THIS_ float *width, THIS_ float *height) PURE;

		STDMETHOD(put_MappingSize) (
			THIS_ float width, THIS_ float height) PURE;

		STDMETHOD(get_NumPointerInput) (
			THIS_ unsigned int* numPointerInput) PURE;

		// Extension Properties
		STDMETHOD(get_NumPointerShape) (
			THIS_ unsigned int *count
		) PURE;

		STDMETHOD(add_PointerShape) (
			THIS_ const char * filename
		) PURE;

		STDMETHOD(remove_PointerShape) (
			THIS_ unsigned int index
		) PURE;

		STDMETHOD(get_PointerShapeName) (
			THIS_ unsigned int index, THIS_ char * shapename
		) PURE;

		STDMETHOD(put_PointerShapeName) (
			THIS_ unsigned int index, THIS_ const char * shapename
		) PURE;

		STDMETHOD(get_PointerShapeOrigin) (
			THIS_ unsigned int index, THIS_ int* originX, THIS_ int* originY
		) PURE;

		STDMETHOD(put_PointerShapeOrigin) (
			THIS_ unsigned int index, THIS_ int originX, THIS_ int originY
		) PURE;

};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IPOINTERMIXER_H__
