/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IPOINTERPOSITION_H__
#define __IPOINTERPOSITION_H__
//------------------------------------------------------------------------------
#define PP_MAXIMUM_OUTPUTMINIMUM_PERIOD	100
#define PP_MINIMUM_OUTPUTMINIMUM_PERIOD	1
#define PP_MAXIMUM_PHRASE_LENGTH		128
#define PP_MAXIMUM_LOCUS_WIDTH			10
#define PP_MAXIMUM_USERDATA_SIZE		256
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {59A4C998-6993-4a9f-8EB8-A76ED66B1E26}
	DEFINE_GUID(IID_IPointerPosition, 
	0x59a4c998, 0x6993, 0x4a9f, 0x8e, 0xb8, 0xa7, 0x6e, 0xd6, 0x6b, 0x1e, 0x26);

    DECLARE_INTERFACE_(IPointerPosition, IUnknown)
    {
		//
		// Monitor Functions
		//
		STDMETHOD(get_ScreenSize) (
			THIS_ unsigned short *width, THIS_ unsigned short *height) PURE;

		STDMETHOD(get_PointerPosition) (
			THIS_ unsigned short *x, THIS_ unsigned short *y) PURE;

		STDMETHOD(get_ButtonStatus) (
			THIS_ unsigned short *status) PURE;

		STDMETHOD(get_WheelStatus) (
			THIS_ unsigned short *status) PURE;

		STDMETHOD(get_NormalizedPointerPosition) (
			THIS_ float *x, THIS_ float *y) PURE;

		//
		// Standard Settings
		//
		// Output Minimum Period
		STDMETHOD(get_OutputMinimumPeriod) (
			THIS_ unsigned long *period) PURE;

		STDMETHOD(put_OutputMinimumPeriod) (
			THIS_ unsigned long period) PURE;

		// Pointer shape
		enum PointerShapeEnum {
			PPPS_STANDARD,
			PPPS_ARROW,
			PPPS_CIRCLE,
			PPPS_RECTANGLE,
			PPPS_TARGET,
			PPPS_STAR,
			NUM_POINTERSHAPE
		};
		STDMETHOD(get_PointerShape) (
			THIS_ short *pointerShape) PURE;

		STDMETHOD(put_PointerShape) (
			THIS_ short pointerShape) PURE;

		// Pointer color
		STDMETHOD(get_PointerColor) (
			THIS_ unsigned char *color
		) PURE;

		STDMETHOD(put_PointerColor) (
			THIS_ const unsigned char *color
		) PURE;

		// Normalized Origin
		STDMETHOD(get_NormalizedOrigin) (
			THIS_ float *ox, THIS_ float *oy) PURE;

		STDMETHOD(put_NormalizedOrigin) (
			THIS_ float ox, THIS_ float oy) PURE;

		// Normalized Size
		STDMETHOD(get_NormalizedSize) (
			THIS_ float *ow, THIS_ float *oh) PURE;

		STDMETHOD(put_NormalizedSize) (
			THIS_ float ow, THIS_ float oh) PURE;

		//
		// Pointer Locus Settings
		//
		STDMETHOD(get_DrawLocusOn) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_DrawLocusOn) (
			THIS_ bool flag
		) PURE;

		// Locus Draw Button
		STDMETHOD(get_LocusDrawButton) (
			THIS_ unsigned short* buttonStatus
		) PURE;

		STDMETHOD(put_LocusDrawButton) (
			THIS_ unsigned short buttonStatus
		) PURE;

		// Locus Erase Button
		STDMETHOD(get_LocusEraseButton) (
			THIS_ unsigned short* buttonStatus
		) PURE;

		STDMETHOD(put_LocusEraseButton) (
			THIS_ unsigned short buttonStatus
		) PURE;

		// Draw Locus Pointer shape
		STDMETHOD(get_LocusDrawPointerShape) (
			THIS_ short* shape
		) PURE;

		STDMETHOD(put_LocusDrawPointerShape) (
			THIS_ short shape
		) PURE;

		// Draw Locus Pointer color
		STDMETHOD(get_LocusDrawPointerColor) (
			THIS_ unsigned char *color
		) PURE;

		STDMETHOD(put_LocusDrawPointerColor) (
			THIS_ const unsigned char* color
		) PURE;

		// Locus EdgingOn
		STDMETHOD(get_LocusEdgingOn) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_LocusEdgingOn) (
			THIS_ bool flag
		) PURE;

		STDMETHOD(get_LocusBrokenLineOn) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_LocusBrokenLineOn) (
			THIS_ bool flag
		) PURE;

		// Locus Width
		STDMETHOD(get_LocusWidth) (
			THIS_ unsigned short *width
		) PURE;

		STDMETHOD(put_LocusWidth) (
			THIS_ unsigned short width
		) PURE;

		//
		// Phrase Settings
		//
		STDMETHOD(get_ShowPhraseOn) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_ShowPhraseOn) (
			THIS_ bool flag
		) PURE;

		// Phrase Table
		STDMETHOD(get_NumPhrases) (
			THIS_ unsigned int *count
		) PURE;

		STDMETHOD(put_NumPhrases) (
			THIS_ unsigned int count
		) PURE;

		STDMETHOD(add_Phrase) (
			THIS_
		) PURE;

		STDMETHOD(remove_Phrase) (
			THIS_ unsigned int index
		) PURE;

		// Phrase
		STDMETHOD(get_Phrase) (
			THIS_ unsigned int index, char *phrase
		) PURE;

		STDMETHOD(put_Phrase) (
			THIS_ unsigned int index, const char *phrase
		) PURE;

		// Show Phrase Button
		STDMETHOD(get_PhraseShowButton) (
			THIS_ unsigned int index, THIS_ unsigned short* buttonStatus
		) PURE;

		STDMETHOD(put_PhraseShowButton) (
			THIS_ unsigned int index, THIS_ unsigned short buttonStatus
		) PURE;

		// Show Phrase Pointer shape
		STDMETHOD(get_PhraseShowPointerShape) (
			THIS_ unsigned int index, THIS_ short* shape
		) PURE;

		STDMETHOD(put_PhraseShowPointerShape) (
			THIS_ unsigned int index, THIS_ short shape
		) PURE;

		// Show Phrase Pointer color
		STDMETHOD(get_PhraseShowPointerColor) (
			THIS_ unsigned int index, THIS_ unsigned char *color
		) PURE;

		STDMETHOD(put_PhraseShowPointerColor) (
			THIS_ unsigned int index, THIS_ const unsigned char* color
		) PURE;

		//
		// User Data Settings
		//
		STDMETHOD(get_UserData) (
			THIS_ unsigned char* userData, THIS_ unsigned int* size) PURE;

		STDMETHOD(put_UserData) (
			THIS_ const unsigned char* userData, THIS_ unsigned int size) PURE;
    };

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IPOINTERPOSITION_H__
