/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ISCROLL_H__
#define __ISCROLL_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {E7C1D597-F760-483b-AB69-3357E3CAC852}
	DEFINE_GUID(IID_IScroll, 
	0xe7c1d597, 0xf760, 0x483b, 0xab, 0x69, 0x33, 0x57, 0xe3, 0xca, 0xc8, 0x52);

    DECLARE_INTERFACE_(IScroll, IUnknown)
    {
		// Scroll Direction
		enum ScrollDirectionEnum
		{
			SSD_HORIZONTAL,
			SSD_VERTICAL,
			NUM_SCROLLDIRECTION
		};

		STDMETHOD(get_ScrollDirection) (
			THIS_ int *direction
		) PURE;

		STDMETHOD(put_ScrollDirection) (
			THIS_ int direction
		) PURE;

		// Scroll Speed
		STDMETHOD(get_ScrollSpeed) (
			THIS_ int *speed
		) PURE;

		STDMETHOD(put_ScrollSpeed) (
			THIS_ int speed
		) PURE;

		// Reset Position
		STDMETHOD(resetPosition) (
		) PURE;

	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ISCROLL_H__
