/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ISTEREODISPLAY_H__
#define __ISTEREODISPLAY_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {9A86E4F2-D29C-4b25-A8AD-3EDDF1C38559}
	DEFINE_GUID(IID_IStereoDisplay, 
	0x9a86e4f2, 0xd29c, 0x4b25, 0xa8, 0xad, 0x3e, 0xdd, 0xf1, 0xc3, 0x85, 0x59);

    DECLARE_INTERFACE_(IStereoDisplay, IUnknown)
    {
		STDMETHOD(get_Flip) (
			THIS_ bool* flip
		) PURE;

		STDMETHOD(put_Flip) (
			THIS_ bool flip
		) PURE;

		enum VideoColorEnum {
			SDVC_RGB555,
			SDVC_RGB24,
			SDVC_AUTO,
			NUM_SDVC
		};

		STDMETHOD(get_InputVideoColor) (
			THIS_ int* color
		) PURE;

		STDMETHOD(put_InputVideoColor) (
			THIS_ int color
		) PURE;

		STDMETHOD(get_FrameRate) (
			THIS_ int* rate
		) PURE;

		STDMETHOD(put_FrameRate) (
			THIS_ int rate
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ISTEREODISPLAY_H__
