/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ISTILLPICTURE_H__
#define __ISTILLPICTURE_H__
//------------------------------------------------------------------------------
#define SP_MAXIMUM_FILENAME_LENGTH 2048
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {9CA34E1E-6AB2-4af0-B095-10BE64F6B35A}
	DEFINE_GUID(IID_IStillPicture, 
	0x9ca34e1e, 0x6ab2, 0x4af0, 0xb0, 0x95, 0x10, 0xbe, 0x64, 0xf6, 0xb3, 0x5a);

    DECLARE_INTERFACE_(IStillPicture, IUnknown)
    {
		enum VideoResolutionEnum {
			SPVR_SQCIF,
			SPVR_QCIF,
			SPVR_CIF,
			SPVR_160x120,
			SPVR_320x240,
			SPVR_360x240,
			SPVR_640x480,
			SPVR_720x480,
			SPVR_800x600,
			SPVR_1024x768,
			SPVR_1280x1024,
			SPVR_1600x1200,
			SPVR_HDTV720P,
			SPVR_HDTV1080I,
			SPVR_SDTV480P,
			SPVR_SDTV480I,
			SPVR_THROUGH,
			SPVR_UNRECOGNIZED = SPVR_THROUGH,
			NUM_SPVR
		};

		STDMETHOD(get_OutputVideoResolution) (
			THIS_ int *videoResolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (
			THIS_ int videoResolution
		) PURE;

		enum OutputModeEnum {
			SPOM_STRETCHTOVIDEO,
			SPOM_KEEPASPECTV,
			SPOM_KEEPASPECTH,
			SPOM_KEEPASPECTHV,
			NUM_SPOM
		};
		STDMETHOD(get_OutputMode) (
			THIS_ int* mode
		) PURE;

		STDMETHOD(put_OutputMode) (
			THIS_ int mode
		) PURE;

		STDMETHOD(get_Filename) (
			THIS_ char* filename
		) PURE;

		STDMETHOD(put_Filename) (
			THIS_ const char* filename
		) PURE;

		STDMETHOD(get_FrameRate) (
			THIS_ int *frameRate
		) PURE;

		STDMETHOD(put_FrameRate) (
			THIS_ int frameRate
		) PURE;

		STDMETHOD(get_NoiseOn) (
			THIS_ bool *noiseOn
		) PURE;

		STDMETHOD(put_NoiseOn) (
			THIS_ bool noiseOn
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ISTILLPICTURE_H__
