/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ISYNCBUFFER_H__
#define __ISYNCBUFFER_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {B4E12DF9-B38D-4f6b-81ED-77837A86E99D}
	DEFINE_GUID(IID_ISyncBuffer, 
	0xb4e12df9, 0xb38d, 0x4f6b, 0x81, 0xed, 0x77, 0x83, 0x7a, 0x86, 0xe9, 0x9d);

    DECLARE_INTERFACE_(ISyncBuffer, IUnknown)
	{
		STDMETHOD(get_AbsoluteTime) (
			THIS_ __int64 *absoluteTime
		) PURE;

		STDMETHOD(get_OffsetAbsoluteTime) (
			THIS_ __int64 *offsetAbsoluteTime
		) PURE;

		STDMETHOD(get_BufferedSampleSize) (
			THIS_ unsigned int *sampleSize
		) PURE;

		STDMETHOD(get_NumOmission) (
			THIS_ unsigned int *numOmission
		) PURE;

		STDMETHOD(get_MaximumSampleSize) (
			THIS_ unsigned int *maximumSampleSize
		) PURE;

		STDMETHOD(put_MaximumSampleSize) (
			THIS_ unsigned int maximumSampleSize
		) PURE;

		STDMETHOD(get_OffsetTime) (
			THIS_ long *offsetTime
		) PURE;

		STDMETHOD(put_OffsetTime) (
			THIS_ long offsetTime
		) PURE;

		STDMETHOD(get_TimeIntervalToOmit) (
			THIS_ unsigned long *interval
		) PURE;

		STDMETHOD(put_TimeIntervalToOmit) (
			THIS_ unsigned long interval
		) PURE;

		STDMETHOD(get_EnableClearTimeStamp) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_EnableClearTimeStamp) (
			THIS_ bool flag
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ISYNCBUFFER_H__
