/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __ITEELEX_H__
#define __ITEELEX_H__
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {7FEC40F8-17E1-4e4b-AEB4-A7F31DD95C81}
	DEFINE_GUID(IID_ITEELeX, 
	0x7fec40f8, 0x17e1, 0x4e4b, 0xae, 0xb4, 0xa7, 0xf3, 0x1d, 0xd9, 0x5c, 0x81);

    DECLARE_INTERFACE_(ITEELeX, IUnknown)
    {
		// Flip
		STDMETHOD(get_Flip) (
			THIS_ bool* flip
		) PURE;

		STDMETHOD(put_Flip) (
			THIS_ bool flip
		) PURE;

		// Input Video Color Format
		enum VideoColorEnum {
			TVC_RGB555,
			TVC_RGB24,
			TVC_AUTO,
			NUM_TVC
		};

		STDMETHOD(get_InputVideoColor) (
			THIS_ int* color
		) PURE;

		STDMETHOD(put_InputVideoColor) (
			THIS_ int color
		) PURE;

		// Video Offset
		STDMETHOD(get_LeftVideoOffset) (
			THIS_ int* x, THIS_ int* y
		) PURE;

		STDMETHOD(put_LeftVideoOffset) (
			THIS_ int x, THIS_ int y
		) PURE;

		STDMETHOD(get_RightVideoOffset) (
			THIS_ int* x, THIS_ int* y
		) PURE;

		STDMETHOD(put_RightVideoOffset) (
			THIS_ int x, THIS_ int y
		) PURE;

		// Video Size
		STDMETHOD(get_LeftVideoSizeOriginal) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_LeftVideoSizeOriginal) (
			THIS_ bool flag
		) PURE;

		STDMETHOD(get_LeftVideoSize) (
			THIS_ unsigned int* width, THIS_ unsigned int* height
		) PURE;

		STDMETHOD(put_LeftVideoSize) (
			THIS_ unsigned int width, THIS_ unsigned int height
		) PURE;

		STDMETHOD(get_RightVideoSizeOriginal) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_RightVideoSizeOriginal) (
			THIS_ bool flag
		) PURE;

		STDMETHOD(get_RightVideoSize) (
			THIS_ unsigned int* width, THIS_ unsigned int* height
		) PURE;

		STDMETHOD(put_RightVideoSize) (
			THIS_ unsigned int width, THIS_ unsigned int height
		) PURE;

		// Output Video Resolution
		enum VideoResolutionEnum {
			TVR_800x600 = 0,
			TVR_1600x600,
			TVR_1024x768,
			TVR_2048x768,
			TVR_1280x1024,
			TVR_2560x1024,
			TVR_1600x1200,
			TVR_3200x1200,
			TVR_800x300,
			TVR_1024x384,
			TVR_1280x512,
			NUM_TVR
		};

		STDMETHOD(get_OutputVideoResolution) (
			THIS_ int* resolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (
			THIS_ int resolution
		) PURE;

		// Frame Rate
		STDMETHOD(get_FrameRate) (
			THIS_ int* rate
		) PURE;

		STDMETHOD(put_FrameRate) (
			THIS_ int rate
		) PURE;

		// Background Color
		STDMETHOD(get_BackgroundColor) (
			THIS_ unsigned char* r, THIS_ unsigned char* g, THIS_ unsigned char* b
		) PURE;

		STDMETHOD(put_BackgroundColor) (
			THIS_ unsigned char r, THIS_ unsigned char g, THIS_ unsigned char b
		) PURE;

		// Video Renderer Control
		STDMETHOD(DoVideoRenderFullscreen) (
		) PURE;

		STDMETHOD(DoVideoRenderBorderOnOff) (
		) PURE;

		STDMETHOD(UpdateVideoRenderPosition) (
		) PURE;

		STDMETHOD(UpdateVideoRenderSize) (
		) PURE;

		STDMETHOD(get_VideoRenderPosition) (
			THIS_ int *x, THIS_ int *y
		) PURE;

		STDMETHOD(put_VideoRenderPosition) (
			THIS_ int x, THIS_ int y
		) PURE;

		STDMETHOD(get_VideoRenderSizeOriginal) (
			THIS_ bool *flag
		) PURE;

		STDMETHOD(put_VideoRenderSizeOriginal) (
			THIS_ bool flag
		) PURE;

		STDMETHOD(get_VideoRenderSize) (
			THIS_ unsigned int* width, THIS_ unsigned int* height
		) PURE;

		STDMETHOD(put_VideoRenderSize) (
			THIS_ unsigned int width, THIS_ unsigned int height
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __ITEELEX_H__
