/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __IVIDEOEXTRACT_H__
#define __IVIDEOEXTRACT_H__

#ifdef __cplusplus
extern "C" {
#endif

	// {CB9E80F7-E556-4b40-B619-D7A8D9FF9FA7}
	DEFINE_GUID(IID_IVideoExtract, 
	0xcb9e80f7, 0xe556, 0x4b40, 0xb6, 0x19, 0xd7, 0xa8, 0xd9, 0xff, 0x9f, 0xa7);

    DECLARE_INTERFACE_(IVideoExtract, IUnknown)
    {
		enum VideoResolutionEnum {
			VR_SQCIF,
			VR_QCIF,
			VR_CIF,
			VR_160x120,
			VR_320x240,
			VR_360x240,
			VR_640x480,
			VR_720x480,
			VR_800x600,
			VR_1024x768,
			VR_1280x1024,
			VR_1600x1200,
			VR_HDTV720P,
			VR_HDTV1080I,
			VR_SDTV480P,
			VR_SDTV480I,
			VR_AUTO,
			NUM_VR
		};
		STDMETHOD(get_OutputVideoResolution) (THIS_
			unsigned int *videoResolution
		) PURE;

		STDMETHOD(put_OutputVideoResolution) (THIS_
			unsigned int videoResolution
		) PURE;

		enum MaskEnum {
			M_RECTANGLE,
			M_ELLIPSE,
			M_CHECKERS,
			NUM_M
		};
		STDMETHOD(get_Mask) (THIS_
			unsigned int *mask
		) PURE;

		STDMETHOD(put_Mask) (THIS_
			unsigned int mask
		) PURE;

		enum BackgroundColorEnum {
			BGC_BLACK,
			BGC_RED,
			BGC_GREEN,
			BGC_BLUE,
			NUM_BGC
		};
		STDMETHOD(get_BackgroundColor) (THIS_
			unsigned int *bgColor
		) PURE;

		STDMETHOD(put_BackgroundColor) (THIS_
			unsigned int bgColor
		) PURE;

		STDMETHOD(get_CutPosition) (THIS_
			int *x, int *y
		) PURE;

		STDMETHOD(put_CutPosition) (THIS_
			int x, int y
		) PURE;

		STDMETHOD(get_PointerInDisable) (THIS_
			bool* flag
		) PURE;

		STDMETHOD(put_PointerInDisable) (THIS_
			bool flag
		) PURE;

		STDMETHOD(get_CheckerGridXY) (THIS_
			unsigned int *x, unsigned int *y
		) PURE;

		STDMETHOD(put_CheckerGridXY) (THIS_
			unsigned int x, unsigned int y
		) PURE;

	};

#ifdef __cplusplus
}
#endif

#endif // __IIMAGESAMPLE_H__

