/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __IVIDEOOVERLAYMIXER_H__
#define __IVIDEOOVERLAYMIXER_H__

#ifdef __cplusplus
extern "C" {
#endif

	// {DEC92EFC-4F94-4c70-86A1-F529D58A1397}
	DEFINE_GUID(IID_IVideoOverlayMixer, 
	0xdec92efc, 0x4f94, 0x4c70, 0x86, 0xa1, 0xf5, 0x29, 0xd5, 0x8a, 0x13, 0x97);

    DECLARE_INTERFACE_(IVideoOverlayMixer, IUnknown)
    {
		enum TimeStampEnum {
			TS_BASE = 0,
			TS_ADDITIONAL,
			TS_ORIGINAL,
			NUM_TS
		};
		STDMETHOD(get_TimeStamp) (THIS_
			unsigned int *timeStamp
		) PURE;

		STDMETHOD(put_TimeStamp) (THIS_
			unsigned int timeStamp
		) PURE;

		STDMETHOD(get_TimeStampZero) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(put_TimeStampZero) (THIS_
			bool flag
		) PURE;

		STDMETHOD(get_TimeOffset) (THIS_
			int *timeOffset
		) PURE;

		STDMETHOD(put_TimeOffset) (THIS_
			int timeOffset
		) PURE;

		STDMETHOD(get_FrameRate) (THIS_
			int *rate
		) PURE;

		STDMETHOD(put_FrameRate) (THIS_
			int rate
		) PURE;

		enum MaskEnum {
			M_RECTANGLE,
			M_ELLIPSE,
			M_CHECKERS,
			NUM_M
		};
		STDMETHOD(get_Mask) (THIS_
			unsigned int *mask
		) PURE;

		STDMETHOD(put_Mask) (THIS_
			unsigned int mask
		) PURE;

		enum BlendingEnum {
			BL_SIMPLE,
			BL_VAGUELY,
			NUM_BL
		};
		STDMETHOD(get_Blending) (THIS_
			unsigned int *bgColor
		) PURE;

		STDMETHOD(put_Blending) (THIS_
			unsigned int bgColor
		) PURE;

		STDMETHOD(get_CompPosition) (THIS_
			int *x, int *y
		) PURE;

		STDMETHOD(put_CompPosition) (THIS_
			int x, int y
		) PURE;

		STDMETHOD(get_PointerInDisable) (THIS_
			bool* flag
		) PURE;

		STDMETHOD(put_PointerInDisable) (THIS_
			bool flag
		) PURE;

		STDMETHOD(get_CheckerGridXY) (THIS_
			unsigned int *x, unsigned int *y
		) PURE;

		STDMETHOD(put_CheckerGridXY) (THIS_
			unsigned int x, unsigned int y
		) PURE;

	};

#ifdef __cplusplus
}
#endif

#endif // __IVIDEOOVERLAYMIXER_H__

