/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __IVIDEOQUADSPLITTER_H__
#define __IVIDEOQUADSPLITTER_H__

#ifdef __cplusplus
extern "C" {
#endif

	// {1C87FB02-800C-4575-BC69-F8475B23C2DB}
	DEFINE_GUID(IID_IVideoQuadSplitter, 
	0x1c87fb02, 0x800c, 0x4575, 0xbc, 0x69, 0xf8, 0x47, 0x5b, 0x23, 0xc2, 0xdb);

    DECLARE_INTERFACE_(IVideoQuadSplitter, IUnknown)
    {
		enum TimeStampEnum {
			TS_IN0 = 0,
			TS_IN1,
			TS_IN2,
			TS_IN3,
			TS_ORIGINAL,
			NUM_TS
		};
		STDMETHOD(get_TimeStamp) (THIS_
			unsigned int *timeStamp
		) PURE;

		STDMETHOD(put_TimeStamp) (THIS_
			unsigned int timeStamp
		) PURE;

		STDMETHOD(get_TimeStampZero) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(put_TimeStampZero) (THIS_
			bool flag
		) PURE;

		STDMETHOD(get_TimeOffset) (THIS_
			int *timeOffset
		) PURE;

		STDMETHOD(put_TimeOffset) (THIS_
			int timeOffset
		) PURE;

		enum BackgroundColorEnum {
			BGC_BLACK,
			BGC_RED,
			BGC_GREEN,
			BGC_BLUE,
			NUM_BGC
		};
		STDMETHOD(get_BackgroundColor) (THIS_
			unsigned int *bgColor
		) PURE;

		STDMETHOD(put_BackgroundColor) (THIS_
			unsigned int bgColor
		) PURE;

		STDMETHOD(get_FrameRate) (THIS_
			int *rate
		) PURE;

		STDMETHOD(put_FrameRate) (THIS_
			int rate
		) PURE;

		STDMETHOD(get_BorderLineOn) (THIS_
			bool *flag
		) PURE;

		STDMETHOD(put_BorderLineOn) (THIS_
			bool flag
		) PURE;

	};

#ifdef __cplusplus
}
#endif

#endif // __IVIDEOQUADSPLITTER_H__

