/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IVOLUMEGRAPH_H__
#define __IVOLUMEGRAPH_H__
//------------------------------------------------------------------------------
#include <flTypes/VolumeInfo.h>
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {C8E036B0-E742-43a4-94CD-E72A587F33CB}
	DEFINE_GUID(IID_IVolumeGraph, 
	0xc8e036b0, 0xe742, 0x43a4, 0x94, 0xcd, 0xe7, 0x2a, 0x58, 0x7f, 0x33, 0xcb);

    DECLARE_INTERFACE_(IVolumeGraph, IUnknown)
    {
		STDMETHOD(get_NumInputs) (
			THIS_ unsigned int *numInputs
		) PURE;

		STDMETHOD(get_Volume) (
			THIS_ unsigned int inputIndex,
			THIS_ VolumeInfo *volume
		) PURE;

		STDMETHOD(get_EvaluationTime) (
			THIS_ unsigned long* evalTime
		) PURE;

		STDMETHOD(put_EvaluationTime) (
			THIS_ unsigned long evalTime
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IVOLUMEGRAPH_H__
