/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __IVOLUMEINDICATOR_H__
#define __IVOLUMEINDICATOR_H__
//------------------------------------------------------------------------------
#include <flTypes/VolumeInfo.h>
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

	// {ABD62C9A-EC4D-45d3-A759-B3F287777B19}
	DEFINE_GUID(IID_IVolumeIndicator, 
	0xabd62c9a, 0xec4d, 0x45d3, 0xa7, 0x59, 0xb3, 0xf2, 0x87, 0x77, 0x7b, 0x19);

    DECLARE_INTERFACE_(IVolumeIndicator, IUnknown)
    {
		STDMETHOD(get_Channels) (
			THIS_ unsigned short* channels
		) PURE;

		STDMETHOD(get_BitsPerSample) (
			THIS_ unsigned short* bitsPerSample
		) PURE;

		STDMETHOD(get_SamplesPerSec) (
			THIS_ unsigned int* samplesPerSec
		) PURE;

		STDMETHOD(get_Volume) (
			THIS_ VolumeInfo *volume
		) PURE;

		STDMETHOD(get_EvaluationTime) (
			THIS_ unsigned long *time
		) PURE;

		STDMETHOD(put_EvaluationTime) (
			THIS_ unsigned long time
		) PURE;
	};

#ifdef __cplusplus
}
#endif
//------------------------------------------------------------------------------
#endif // __IVOLUMEINDICATOR_H__
