/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __PointerInfo_h__
#define __PointerInfo_h__
//------------------------------------------------------------------------------

//
// PointerInfo SubType
//
// Major Type				: MAJORTYPE_Stream
// Fixed Size Sample		: FALSE
// Temporal Compression		: FALSE
// Allocator Buffer Size	: 1024 byte
//
// {F7195551-5EAF-44c0-89A4-BB0F3FBD7294}
DEFINE_GUID(MEDIASUBTYPE_PointerInfo, 
0xf7195551, 0x5eaf, 0x44c0, 0x89, 0xa4, 0xbb, 0xf, 0x3f, 0xbd, 0x72, 0x94);

//------------------------------------------------------------------------------

// Suggest Default Media Sample Allocator size
#define PI_DEFAULTSAMPLESIZE			1024

//------------------------------------------------------------------------------

/*
*	PointerInfo Media Sample Format
*
*	int DataCount
*	Data1 Identifier
*	Data1 Data
*	Data2 Identifier
*	Data2 Data
*	 :
*/

/*
*	PIID_POINTERSHAPE
*	short		shape
*/
#define PIID_POINTERSHAPE				0x0001

/*
*	PIID_POINTERCOLOR
*	unsigned char	color[3]
*/
#define PIID_POINTERCOLOR				0x0002

/*
*	PIID_SCREENSIZE
*	unsigned short	size[2]
*/
#define PIID_SCREENSIZE					0x0004

/*
*	PIID_POINTERPOSITION
*	unsigned short	pos[2]
*/
#define PIID_POINTERPOSITION			0x0008

/*
*	PIID_BUTTONSTATUS
*	unsigned short	status
*/
#define PIID_BUTTONSTATUS				0x0010

/*
*	PIID_WHEELSTATUS
*	unsigned short	status
*/
#define PIID_WHEELSTATUS				0x0020

/*
*	PIID_DRAWSTATUS
*	unsigned short	status
*/
/*
*	
*	0		Draw Locus On
*	1		Show Phrase On
*	2		Draw Locus
*	3		Erase Locus
*	4		Show Phrase
*   8		Edging On
*   9		BrokenLine On
*	12-15	Locus width
*/
#define PIID_DRAWSTATUS					0x0040

/*
*	PIID_PHRASE
*	unsigned int	dataSize
*	unsigned char	data[ < PI_MAXIMUM_PHRASE_LENGTH]
*/
#define PIID_PHRASE						0x0080

/*
*	PIID_NORMALIZEDORIGIN
*	float	pos[2]
*/
#define PIID_NORMALIZEDORIGIN			0x0100

/*
*	PIID_NORMALIZEDSIZE
*	float	size[2]
*/
#define PIID_NORMALIZEDSIZE				0x0200

/*
*	PIID_NORMALIZEDPOINTERPOSITION
*	float	pos[2]
*/
#define PIID_NORMALIZEDPOINTERPOSITION	0x0400

/*
*	PIID_USERDATA
*	unsigned int		dataSize
*	unsigned char data[ < PI_MAXIMUM_USERDATA_SIZE]
*/
#define PIID_USERDATA					0x0800

#define PIID_ALL						0xffff

//------------------------------------------------------------------------------
#define PI_MAXIMUM_PHRASE_LENGTH		128
#define PI_MAXIMUM_USERDATA_SIZE		256

//------------------------------------------------------------------------------
// Access Draw locus On flag
#define PI_GETDRAWLOCUSON(__status, __flag)					\
	__flag = (((__status) & 0x0001) != 0);
#define PI_SETDRAWLOCUSON(__status, __flag)					\
	__status = (((__status) & 0xFFFE) | ((__flag) ? 0x1 : 0x0));

//------------------------------------------------------------------------------
// Access Draw phrase On flag
#define PI_GETSHOWPHRASEON(__status, __flag)					\
	__flag = (((__status) & 0x0002) != 0);
#define PI_SETSHOWPHRASEON(__status, __flag)					\
	__status = (((__status) & 0xFFFD) | ((__flag) ? 0x2 : 0x0));

//------------------------------------------------------------------------------
// Access Draw locus flag
#define PI_GETDRAWLOCUS(__status, __flag)					\
	__flag = (((__status) & 0x0004) != 0);
#define PI_SETDRAWLOCUS(__status, __flag)					\
	__status = (((__status) & 0xFFFB) | ((__flag) ? 0x4 : 0x0));

//------------------------------------------------------------------------------
// Access Erase locus flag
#define PI_GETERASELOCUS(__status, __flag)					\
	__flag = (((__status) & 0x0008) != 0);
#define PI_SETERASELOCUS(__status, __flag)					\
	__status = (((__status) & 0xFFF7) | ((__flag) ? 0x8 : 0x0));

//------------------------------------------------------------------------------
// Access Show phrase flag
#define PI_GETSHOWPHRASE(__status, __flag)					\
	__flag = (((__status) & 0x0010) != 0);
#define PI_SETSHOWPHRASE(__status, __flag)					\
	__status = (((__status) & 0xFFEF) | ((__flag) ? 0x10 : 0x0));

//------------------------------------------------------------------------------
// Access Locus EdgingOn
#define PI_GETEDGINGON(__status, __flag)					\
	__flag = (((__status) & 0x100) != 0);
#define PI_SETEDGINGON(__status, __flag)					\
	__status = (((__status) & 0xFEFF) | (((__flag) & 0x01) << 8));

//------------------------------------------------------------------------------
// Access Locus EdgingOn
#define PI_GETBROKENLINEON(__status, __flag)				\
	__flag = (((__status) & 0x200) != 0);
#define PI_SETBROKENLINEON(__status, __flag)				\
	__status = (((__status) & 0xFDFF) | (((__flag) & 0x01) << 9));

//------------------------------------------------------------------------------
// Access Locus width
#define PI_GETLOCUSWIDTH(__status, __width)					\
	__width = (((__status) & 0xF000) >> 12);
#define PI_SETLOCUSWIDTH(__status, __width)					\
	__status = (((__status) & 0x0FFF) | (((__width) & 0xF) << 12));

//------------------------------------------------------------------------------
#endif //__PointerInfo_h__
