/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flUIDs_h__
#define __flUIDs_h__
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//
// AudioMixer
//
//------------------------------------------------------------------------------
// AudioMixer Filter Object
// {44CDE2E9-C6F4-46d0-88FE-5478EA099F96}
DEFINE_GUID(CLSID_AudioMixer, 
0x44cde2e9, 0xc6f4, 0x46d0, 0x88, 0xfe, 0x54, 0x78, 0xea, 0x9, 0x9f, 0x96);


//------------------------------------------------------------------------------
//
// Noise Filter
//
//------------------------------------------------------------------------------
// Noise Filter Object
// {6CD30BFD-94C8-450e-B960-395D426020B4}
DEFINE_GUID(CLSID_Noise, 
0x6cd30bfd, 0x94c8, 0x450e, 0xb9, 0x60, 0x39, 0x5d, 0x42, 0x60, 0x20, 0xb4);

// Noise Property Page
// {6A176863-AE35-488a-A953-935B95DC7CC7}
DEFINE_GUID(CLSID_NoisePropertyPage, 
0x6a176863, 0xae35, 0x488a, 0xa9, 0x53, 0x93, 0x5b, 0x95, 0xdc, 0x7c, 0xc7);


//------------------------------------------------------------------------------
//
// Ghost Filter
//
//------------------------------------------------------------------------------
// Ghost Filter Object
// {07489AA2-BD7C-4f34-A983-A6EB946CE36E}
DEFINE_GUID(CLSID_Ghost, 
0x7489aa2, 0xbd7c, 0x4f34, 0xa9, 0x83, 0xa6, 0xeb, 0x94, 0x6c, 0xe3, 0x6e);

// Ghost Property Page
// {B921AF40-C2BE-4b8d-B54B-CB542E79F6DD}
DEFINE_GUID(CLSID_GhostPropertyPage, 
0xb921af40, 0xc2be, 0x4b8d, 0xb5, 0x4b, 0xcb, 0x54, 0x2e, 0x79, 0xf6, 0xdd);


//------------------------------------------------------------------------------
//
// Scroll Filter
//
//------------------------------------------------------------------------------
// Scroll Filter Object
// {5FAC7A42-A550-4ebc-89DC-51F17BD403E8}
DEFINE_GUID(CLSID_Scroll, 
0x5fac7a42, 0xa550, 0x4ebc, 0x89, 0xdc, 0x51, 0xf1, 0x7b, 0xd4, 0x3, 0xe8);

// Scroll Property Page
// {BC213AD8-4D26-443b-A202-2635FEB13FC0}
DEFINE_GUID(CLSID_ScrollPropertyPage, 
0xbc213ad8, 0x4d26, 0x443b, 0xa2, 0x2, 0x26, 0x35, 0xfe, 0xb1, 0x3f, 0xc0);


//------------------------------------------------------------------------------
//
// Frame Rate Controller
//
//------------------------------------------------------------------------------
// FrameControl Filter Object
// {9BDF93BC-EA40-4933-B705-D2F9D7B10397}
DEFINE_GUID(CLSID_FrameControl, 
0x9bdf93bc, 0xea40, 0x4933, 0xb7, 0x5, 0xd2, 0xf9, 0xd7, 0xb1, 0x3, 0x97);

// FrameControl Property Page
// {A2651D87-9198-4d08-984C-556518AE68A4}
DEFINE_GUID(CLSID_FrameControlPropertyPage, 
0xa2651d87, 0x9198, 0x4d08, 0x98, 0x4c, 0x55, 0x65, 0x18, 0xae, 0x68, 0xa4);


//------------------------------------------------------------------------------
//
// Subliminal Filter
//
//------------------------------------------------------------------------------
// Subliminal Filter Object
// {9F0CF6D8-25A9-46d2-8F79-C4E4394BD877}
DEFINE_GUID(CLSID_Subliminal, 
0x9f0cf6d8, 0x25a9, 0x46d2, 0x8f, 0x79, 0xc4, 0xe4, 0x39, 0x4b, 0xd8, 0x77);

// Subliminal Property Page
// {522F741C-244E-415c-93DC-F8ADCFD05A0C}
DEFINE_GUID(CLSID_SubliminalPropertyPage, 
0x522f741c, 0x244e, 0x415c, 0x93, 0xdc, 0xf8, 0xad, 0xcf, 0xd0, 0x5a, 0xc);


//------------------------------------------------------------------------------
//
// Digital Clock
//
//------------------------------------------------------------------------------
// DigitalClock Filter Object
// {D1D9739E-1205-4771-BF1D-A5BA7E798D88}
DEFINE_GUID(CLSID_DigitalClock, 
0xd1d9739e, 0x1205, 0x4771, 0xbf, 0x1d, 0xa5, 0xba, 0x7e, 0x79, 0x8d, 0x88);

// DigitalClock Property Page
// {D4A899AB-83C6-40d5-8473-DA98F42FEA5F}
DEFINE_GUID(CLSID_DigitalClockPropertyPage, 
0xd4a899ab, 0x83c6, 0x40d5, 0x84, 0x73, 0xda, 0x98, 0xf4, 0x2f, 0xea, 0x5f);


//------------------------------------------------------------------------------
//
// TEELeX
//
//------------------------------------------------------------------------------
// TEELeX Filter Object
// {F440C814-DEA6-49d1-9C50-58B049F74101}
DEFINE_GUID(CLSID_TEELeX, 
0xf440c814, 0xdea6, 0x49d1, 0x9c, 0x50, 0x58, 0xb0, 0x49, 0xf7, 0x41, 0x1);

// TEELeX Property Page
// {0A12C4E3-1AD8-4500-803B-E82B4371D5A5}
DEFINE_GUID(CLSID_TEELeXPropertyPage, 
0xa12c4e3, 0x1ad8, 0x4500, 0x80, 0x3b, 0xe8, 0x2b, 0x43, 0x71, 0xd5, 0xa5);


//------------------------------------------------------------------------------
//
// Stereo Display
//
//------------------------------------------------------------------------------
// StereoDisplay Filter Object
// {46DA993A-2729-4dc3-942D-6A8B84ED43E8}
DEFINE_GUID(CLSID_StereoDisplay, 
0x46da993a, 0x2729, 0x4dc3, 0x94, 0x2d, 0x6a, 0x8b, 0x84, 0xed, 0x43, 0xe8);

// StereoDisplay Property Page
// {37037155-C58B-45f5-97EC-EE9BBD59FA41}
DEFINE_GUID(CLSID_StereoDisplayPropertyPage, 
0x37037155, 0xc58b, 0x45f5, 0x97, 0xec, 0xee, 0x9b, 0xbd, 0x59, 0xfa, 0x41);


//------------------------------------------------------------------------------
//
// GreenShift Filter
//
//------------------------------------------------------------------------------
// GreenShift Filter Object
// {44BA63D7-A24A-4cab-A968-E3145152F265}
DEFINE_GUID(CLSID_GreenShift, 
0x44ba63d7, 0xa24a, 0x4cab, 0xa9, 0x68, 0xe3, 0x14, 0x51, 0x52, 0xf2, 0x65);

// GreenShift Property Page
// {94DC0CEB-DA59-4431-9BD2-7D530E8B65FE}
DEFINE_GUID(CLSID_GreenShiftPropertyPage, 
0x94dc0ceb, 0xda59, 0x4431, 0x9b, 0xd2, 0x7d, 0x53, 0xe, 0x8b, 0x65, 0xfe);


//------------------------------------------------------------------------------
//
// Interlace Filter
//
//------------------------------------------------------------------------------
// Interlace Filter Object
// {B6A46207-F4E6-4afc-9FDA-6FB21218CAD4}
DEFINE_GUID(CLSID_Interlace, 
0xb6a46207, 0xf4e6, 0x4afc, 0x9f, 0xda, 0x6f, 0xb2, 0x12, 0x18, 0xca, 0xd4);

// Interlace Property Page
// {C7521E35-B429-46c1-9808-066391E04E62}
DEFINE_GUID(CLSID_InterlacePropertyPage, 
0xc7521e35, 0xb429, 0x46c1, 0x98, 0x8, 0x6, 0x63, 0x91, 0xe0, 0x4e, 0x62);


//------------------------------------------------------------------------------
//
// 2-Input Level Compressor
//
//------------------------------------------------------------------------------
// LevelCompress Filter Object
// {F5B05DB1-C61D-4d93-96A4-21DBBEC35EB0}
DEFINE_GUID(CLSID_LevelCompress, 
0xf5b05db1, 0xc61d, 0x4d93, 0x96, 0xa4, 0x21, 0xdb, 0xbe, 0xc3, 0x5e, 0xb0);

// LevelCompress Property Page
// {FB5CAD9D-9D4C-46f6-B3D0-A872B243456C}
DEFINE_GUID(CLSID_LevelCompressPropertyPage, 
0xfb5cad9d, 0x9d4c, 0x46f6, 0xb3, 0xd0, 0xa8, 0x72, 0xb2, 0x43, 0x45, 0x6c);


//------------------------------------------------------------------------------
//
// Volume Graph
//
//------------------------------------------------------------------------------
// VolumeGraph Filter Object
// {A3FBB25C-C9B1-4198-8951-0110576E911D}
DEFINE_GUID(CLSID_VolumeGraph, 
0xa3fbb25c, 0xc9b1, 0x4198, 0x89, 0x51, 0x1, 0x10, 0x57, 0x6e, 0x91, 0x1d);

// VolumeGraph Property Page
// {1FB29B0A-DE28-4edb-B401-FB95D26DB1AC}
DEFINE_GUID(CLSID_VolumeGraphPropertyPage, 
0x1fb29b0a, 0xde28, 0x4edb, 0xb4, 0x1, 0xfb, 0x95, 0xd2, 0x6d, 0xb1, 0xac);


//------------------------------------------------------------------------------
//
// Volume Indicator
//
//------------------------------------------------------------------------------
// VolumeIndicator Filter Object
// {C45458D5-DB4C-45b4-8B3D-4B62C8308FE3}
DEFINE_GUID(CLSID_VolumeIndicator, 
0xc45458d5, 0xdb4c, 0x45b4, 0x8b, 0x3d, 0x4b, 0x62, 0xc8, 0x30, 0x8f, 0xe3);

// VolumeIndicator Property Page
// {A35F2DE7-0CAC-46b1-BC66-7DA6284E1CDA}
DEFINE_GUID(CLSID_VolumeIndicatorPropertyPage, 
0xa35f2de7, 0xcac, 0x46b1, 0xbc, 0x66, 0x7d, 0xa6, 0x28, 0x4e, 0x1c, 0xda);


//------------------------------------------------------------------------------
//
// Synchronizing Buffer
//
//------------------------------------------------------------------------------
// SyncBuffer Filter Object
// {4DB69746-1B0B-4713-9DC3-B89B557CD821}
DEFINE_GUID(CLSID_SyncBuffer, 
0x4db69746, 0x1b0b, 0x4713, 0x9d, 0xc3, 0xb8, 0x9b, 0x55, 0x7c, 0xd8, 0x21);

// SyncBuffer Property Page
// {87347D27-DCB8-4577-B834-46FC1FAC681C}
DEFINE_GUID(CLSID_SyncBufferPropertyPage, 
0x87347d27, 0xdcb8, 0x4577, 0xb8, 0x34, 0x46, 0xfc, 0x1f, 0xac, 0x68, 0x1c);


//------------------------------------------------------------------------------
//
// Still Picture
//
//------------------------------------------------------------------------------
// StillPicture Filter Object
// {90E61B81-359C-490e-9B4B-4B64E8E4F949}
DEFINE_GUID(CLSID_StillPicture, 
0x90e61b81, 0x359c, 0x490e, 0x9b, 0x4b, 0x4b, 0x64, 0xe8, 0xe4, 0xf9, 0x49);

// StillPicture Property Page
// {AB0F03E5-5051-4ca5-BDE2-625A8ACF05FA}
DEFINE_GUID(CLSID_StillPicturePropertyPage, 
0xab0f03e5, 0x5051, 0x4ca5, 0xbd, 0xe2, 0x62, 0x5a, 0x8a, 0xcf, 0x5, 0xfa);


//------------------------------------------------------------------------------
//
// Frame Draw Filter
//
//------------------------------------------------------------------------------
// DrawFrame Filter Object
// {FB2F61C5-8AE8-41af-9EE9-188CDA12DA51}
DEFINE_GUID(CLSID_DrawFrame, 
0xfb2f61c5, 0x8ae8, 0x41af, 0x9e, 0xe9, 0x18, 0x8c, 0xda, 0x12, 0xda, 0x51);

// DrawFrame Property Page
// {2F5EE91D-696F-4cdf-AA70-6186CD5A31B2}
DEFINE_GUID(CLSID_DrawFramePropertyPage,
0x2f5ee91d, 0x696f, 0x4cdf, 0xaa, 0x70, 0x61, 0x86, 0xcd, 0x5a, 0x31, 0xb2);


//------------------------------------------------------------------------------
//
// Caption Draw Filter
//
//------------------------------------------------------------------------------
// DrawCaption Filter Object
// {31302BF8-1C33-4446-9468-4A5C9C8AD17D}
DEFINE_GUID(CLSID_DrawCaption, 
0x31302bf8, 0x1c33, 0x4446, 0x94, 0x68, 0x4a, 0x5c, 0x9c, 0x8a, 0xd1, 0x7d);

// DrawCaption Property Page
// {25CF065F-06E1-44f8-97D1-94BCEDE13335}
DEFINE_GUID(CLSID_DrawCaptionPropertyPage, 
0x25cf065f, 0x6e1, 0x44f8, 0x97, 0xd1, 0x94, 0xbc, 0xed, 0xe1, 0x33, 0x35);


//------------------------------------------------------------------------------
//
// Multicast Sender
//
//------------------------------------------------------------------------------
// MulticastSender Filter Object
// {FFF4CBF9-0DAE-4990-88D2-8186340EFEC1}
DEFINE_GUID(CLSID_MulticastSender, 
0xfff4cbf9, 0xdae, 0x4990, 0x88, 0xd2, 0x81, 0x86, 0x34, 0xe, 0xfe, 0xc1);

// MulticastSender Communication Property Page
// {F990271E-74C1-4d1c-A67C-BD2EAF44C594}
DEFINE_GUID(CLSID_MulticastSenderComPropertyPage, 
0xf990271e, 0x74c1, 0x4d1c, 0xa6, 0x7c, 0xbd, 0x2e, 0xaf, 0x44, 0xc5, 0x94);

// Multicast Server MediaType Property Page
// {88D2EEB0-31E6-4956-BA5E-ADC8AC0E22E5}
DEFINE_GUID(CLSID_MulticastSenderMediaTypePropertyPage, 
0x88d2eeb0, 0x31e6, 0x4956, 0xba, 0x5e, 0xad, 0xc8, 0xac, 0xe, 0x22, 0xe5);

// MulticastSender Frame Control Property Page
// {65CA1A0A-262C-45a7-A606-DAA8686B645C}
DEFINE_GUID(CLSID_MulticastSenderFrameControlPropertyPage, 
0x65ca1a0a, 0x262c, 0x45a7, 0xa6, 0x6, 0xda, 0xa8, 0x68, 0x6b, 0x64, 0x5c);

// MulticastSender User Data Property Page
// {0375753A-60BC-450d-AE8D-8E3DC6F58499}
DEFINE_GUID(CLSID_MulticastSenderUserDataPropertyPage, 
0x375753a, 0x60bc, 0x450d, 0xae, 0x8d, 0x8e, 0x3d, 0xc6, 0xf5, 0x84, 0x99);


//------------------------------------------------------------------------------
//
// Multicast Receiver
//
//------------------------------------------------------------------------------
// MulticastReceiver Filter Object
// {5D74D554-4D9A-47a0-956C-B8A0BC4AD32B}
DEFINE_GUID(CLSID_MulticastReceiver, 
0x5d74d554, 0x4d9a, 0x47a0, 0x95, 0x6c, 0xb8, 0xa0, 0xbc, 0x4a, 0xd3, 0x2b);

// Multicast Client Communication Property Page
// {D67B81D1-D324-427a-AE68-F29D03416BB3}
DEFINE_GUID(CLSID_MulticastReceiverComPropertyPage, 
0xd67b81d1, 0xd324, 0x427a, 0xae, 0x68, 0xf2, 0x9d, 0x3, 0x41, 0x6b, 0xb3);

// Multicast Client MediaType Property Page
// {61DE7A8E-124F-4c3f-981A-77D51F8204F0}
DEFINE_GUID(CLSID_MulticastReceiverMediaTypePropertyPage, 
0x61de7a8e, 0x124f, 0x4c3f, 0x98, 0x1a, 0x77, 0xd5, 0x1f, 0x82, 0x4, 0xf0);

// Multicast Client FrameControl Property Page
// {3E2038C3-F410-4e87-8FEA-5F068AAD8B87}
DEFINE_GUID(CLSID_MulticastReceiverFrameControlPropertyPage, 
0x3e2038c3, 0xf410, 0x4e87, 0x8f, 0xea, 0x5f, 0x6, 0x8a, 0xad, 0x8b, 0x87);

// Multicast Client Rejection Address Property Page
// {A3D7F7F5-F80F-41bc-B85A-620F71017644}
DEFINE_GUID(CLSID_MulticastReceiverRejectionAddressPropertyPage, 
0xa3d7f7f5, 0xf80f, 0x41bc, 0xb8, 0x5a, 0x62, 0xf, 0x71, 0x1, 0x76, 0x44);

// Multicast Client Additional Info Property Page
// {3D9464B1-BE89-48d2-976E-EB1F7D338F35}
DEFINE_GUID(CLSID_MulticastReceiverAdditionalInfoPropertyPage, 
0x3d9464b1, 0xbe89, 0x48d2, 0x97, 0x6e, 0xeb, 0x1f, 0x7d, 0x33, 0x8f, 0x35);


//------------------------------------------------------------------------------
//
// Pointer Position Capture
//
//------------------------------------------------------------------------------
// PointerPosition Filter Object
// {F7B72700-6DD6-4bc2-B9BB-6A75485F8F31}
DEFINE_GUID(CLSID_PointerPosition, 
0xf7b72700, 0x6dd6, 0x4bc2, 0xb9, 0xbb, 0x6a, 0x75, 0x48, 0x5f, 0x8f, 0x31);

// PointerPosition Property page Object
// {2AC82B1E-1989-4fa6-BC2C-67592E942B56}
DEFINE_GUID(CLSID_PointerPositionPropertyPage, 
0x2ac82b1e, 0x1989, 0x4fa6, 0xbc, 0x2c, 0x67, 0x59, 0x2e, 0x94, 0x2b, 0x56);

// PointerPosition Extension Property page Object
// {AD844C85-76C4-4540-888A-52003893B4B7}
DEFINE_GUID(CLSID_PointerPositionExtensionPropertyPage, 
0xad844c85, 0x76c4, 0x4540, 0x88, 0x8a, 0x52, 0x0, 0x38, 0x93, 0xb4, 0xb7);

// PointerPosition User Data Property page Object
// {00A51F95-3B51-4ad9-B0B1-05156ABD98B6}
DEFINE_GUID(CLSID_PointerPositionUserDataPropertyPage, 
0xa51f95, 0x3b51, 0x4ad9, 0xb0, 0xb1, 0x5, 0x15, 0x6a, 0xbd, 0x98, 0xb6);


//------------------------------------------------------------------------------
//
// Video/Pointer Mixer
//
//------------------------------------------------------------------------------
// PointerMixer Filter Object
// {0DA8A340-73DE-471d-80E6-091DD4288C10}
DEFINE_GUID(CLSID_PointerMixer, 
0xda8a340, 0x73de, 0x471d, 0x80, 0xe6, 0x9, 0x1d, 0xd4, 0x28, 0x8c, 0x10);

// PointerMixer Property page Object
// {F49F17B4-EF66-404c-841E-68F2282F0CC9}
DEFINE_GUID(CLSID_PointerMixerPropertyPage, 
0xf49f17b4, 0xef66, 0x404c, 0x84, 0x1e, 0x68, 0xf2, 0x28, 0x2f, 0xc, 0xc9);

// PointerMixer Extension Property page Object
// {43288677-1C4A-4ecd-BBCD-35194E10F632}
DEFINE_GUID(CLSID_PointerMixerExtensionPropertyPage, 
0x43288677, 0x1c4a, 0x4ecd, 0xbb, 0xcd, 0x35, 0x19, 0x4e, 0x10, 0xf6, 0x32);


//------------------------------------------------------------------------------
//
// Video Format Transformer
//
//------------------------------------------------------------------------------
// FormatTrans Filter Object
// {72AE0C79-3FEF-4529-A029-56B2C58E59E1}
DEFINE_GUID(CLSID_FormatTrans, 
0x72ae0c79, 0x3fef, 0x4529, 0xa0, 0x29, 0x56, 0xb2, 0xc5, 0x8e, 0x59, 0xe1);

// FormatTrans Property Page
// {630FDE0D-0895-4c2b-961E-960997753C37}
DEFINE_GUID(CLSID_FormatTransPropertyPage, 
0x630fde0d, 0x895, 0x4c2b, 0x96, 0x1e, 0x96, 0x9, 0x97, 0x75, 0x3c, 0x37);


//------------------------------------------------------------------------------
//
// Video Quad Splitter
//
//------------------------------------------------------------------------------
// VideoQuadSplitter Filter Object
// {F02940B5-BBEA-4948-8B2F-AC9AAD92D324}
DEFINE_GUID(CLSID_VideoQuadSplitter, 
0xf02940b5, 0xbbea, 0x4948, 0x8b, 0x2f, 0xac, 0x9a, 0xad, 0x92, 0xd3, 0x24);

//
// VideoQuadSplitter Property Page
//
// {607847AF-5136-482c-93A3-629C4DDADFE1}
DEFINE_GUID(CLSID_VideoQuadSplitterPropertyPage, 
0x607847af, 0x5136, 0x482c, 0x93, 0xa3, 0x62, 0x9c, 0x4d, 0xda, 0xdf, 0xe1);


//------------------------------------------------------------------------------
//
// 2-input Video Overlay Mixer
//
//------------------------------------------------------------------------------
// VideoOverlayMixer Filter Object
// {C65C2248-FED6-4977-9364-115E7626B6ED}
DEFINE_GUID(CLSID_VideoOverlayMixer, 
0xc65c2248, 0xfed6, 0x4977, 0x93, 0x64, 0x11, 0x5e, 0x76, 0x26, 0xb6, 0xed);

// VideoOverlayMixer Property Page
// {0ABF774B-2E6C-4967-B31A-4CB07FA0B036}
DEFINE_GUID(CLSID_VideoOverlayMixerPropertyPage, 
0xabf774b, 0x2e6c, 0x4967, 0xb3, 0x1a, 0x4c, 0xb0, 0x7f, 0xa0, 0xb0, 0x36);


//------------------------------------------------------------------------------
//
// Video Extraction Filter
//
//------------------------------------------------------------------------------
// VideoExtract Filter Object
// {FA25A260-B89A-4688-8897-681E51A7BBEC}
DEFINE_GUID(CLSID_VideoExtract, 
0xfa25a260, 0xb89a, 0x4688, 0x88, 0x97, 0x68, 0x1e, 0x51, 0xa7, 0xbb, 0xec);

// VideoExtract Property Page
// {3EDA9116-C02F-4532-9A71-C89E4F924BDD}
DEFINE_GUID(CLSID_VideoExtractPropertyPage, 
0x3eda9116, 0xc02f, 0x4532, 0x9a, 0x71, 0xc8, 0x9e, 0x4f, 0x92, 0x4b, 0xdd);


//------------------------------------------------------------------------------
//
// Non-linear Zooming Filter
//
//------------------------------------------------------------------------------
// NonLinearZoom Filter Object
// {E32DBEEE-EF96-4017-AAAB-5271C07ED413}
DEFINE_GUID(CLSID_NonLinearZoom, 
0xe32dbeee, 0xef96, 0x4017, 0xaa, 0xab, 0x52, 0x71, 0xc0, 0x7e, 0xd4, 0x13);

// NonLinearZoom Property Page
// {EC3A757E-30EA-4af0-8954-516CA41C922C}
DEFINE_GUID(CLSID_NonLinearZoomPropertyPage, 
0xec3a757e, 0x30ea, 0x4af0, 0x89, 0x54, 0x51, 0x6c, 0xa4, 0x1c, 0x92, 0x2c);


//------------------------------------------------------------------------------
#endif //__flUIDs_h__
