/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#include <streams.h>
#include <commctrl.h>
#include <olectl.h>
#include <memory.h>
#include "resource.h"

#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include "transfrmn2.h"

#include <flFilterCommon/flPointerInfo.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IVideoExtract.h>

#include "videoextract.h"
#include "videoextractprop.h"


//
// CreateInstance
//
// This goes in the factory template table to create new filter instances
//
CUnknown * WINAPI CVideoExtractProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CVideoExtractProperties(lpunk, phr);
    if (punk == NULL) {
	*phr = E_OUTOFMEMORY;
    }
    return punk;

} // CreateInstance


//
// Constructor
//
CVideoExtractProperties::CVideoExtractProperties(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("VideoExtractProp"),pUnk,
                      IDD_VIDEOEXTRACTPROP,
                      IDS_TITLE),
    m_pVideoExtract(NULL)
{
    InitCommonControls();

} // (Constructor)


//
// SetDirty
//
// Sets m_bDirty and notifies the property page site of the change
//
void CVideoExtractProperties::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite) {
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

} // SetDirty


//
// OnReceiveMessage
//
// Virtual method called by base class with Window messages
//
BOOL CVideoExtractProperties::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			SetupItems();

			if (_iMask == 2)
			{
				Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), true);
			} else {
				Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), false);
			}

			return (LRESULT) 1;

		}
        case WM_COMMAND:
        {

			switch(LOWORD(wParam))
			{
			case IDC_OUT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO));
					pIVideoExtract()->put_OutputVideoResolution(sel);
					SetDirty();
				}
				break;
			case IDC_MASK_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO));
					pIVideoExtract()->put_Mask(sel);

					if (sel == 2)
					{
						Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), true);
					} else {
						Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), false);
					}

					SetDirty();
				}
				break;
			case IDC_BGCOLOR_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO));
					pIVideoExtract()->put_BackgroundColor(sel);
					SetDirty();
				}
				break;
			case IDC_CUTX_EDIT:
			case IDC_CUTY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int x, y;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_CUTX_EDIT), sz, STR_MAX_LENGTH);
					x = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_CUTY_EDIT), sz, STR_MAX_LENGTH);
					y = atoi(sz);
					pIVideoExtract()->put_CutPosition(x, y);

					SetDirty();
				}
				break;
			case IDC_PINDISABLE_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK)) == TRUE);
					pIVideoExtract()->put_PointerInDisable(flag);

					SetDirty();
				}
				break;
			case IDC_GRIDX_EDIT:
			case IDC_GRIDY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int x, y;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), sz, STR_MAX_LENGTH);
					x = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), sz, STR_MAX_LENGTH);
					y = atoi(sz);
					pIVideoExtract()->put_CheckerGridXY(x, y);

					SetDirty();
				}
				break;
			}

			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);

} // OnReceiveMessage


//
// OnConnect
//
// Called when the property page connects to a filter
//
HRESULT CVideoExtractProperties::OnConnect(IUnknown *pUnknown)
{
    ASSERT(m_pVideoExtract == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IVideoExtract, (void **) &m_pVideoExtract);
    if (FAILED(hr)) {
        return E_NOINTERFACE;
    }

    ASSERT(m_pVideoExtract);

	m_pVideoExtract->get_OutputVideoResolution(&_iOutputVideoResolution);
	_iOutputVideoResolutionOnExit = _iOutputVideoResolution;

	m_pVideoExtract->get_Mask(&_iMask);
	_iMaskOnExit = _iMask;

	m_pVideoExtract->get_BackgroundColor(&_iBGColor);
	_iBGColorOnExit = _iBGColor;

	m_pVideoExtract->get_CutPosition(&_iCutPosX, &_iCutPosY);
	_iCutPosXOnExit = _iCutPosX;
	_iCutPosYOnExit = _iCutPosY;

	m_pVideoExtract->get_PointerInDisable(&_bPointerInDisable);
	_bPointerInDisableOnExit = _bPointerInDisable;

	m_pVideoExtract->get_CheckerGridXY(&_iGridX, &_iGridY);
	_iGridXOnExit = _iGridX;
	_iGridYOnExit = _iGridY;


	return NOERROR;

} // OnConnect


//
// OnDisconnect
//
// Called when we're disconnected from a filter
//
HRESULT CVideoExtractProperties::OnDisconnect()
{
    if (m_pVideoExtract == NULL) {
        return E_UNEXPECTED;
    }

	m_pVideoExtract->put_OutputVideoResolution(_iOutputVideoResolutionOnExit);
	m_pVideoExtract->put_Mask(_iMaskOnExit);
	m_pVideoExtract->put_BackgroundColor(_iBGColorOnExit);
	m_pVideoExtract->put_CutPosition(_iCutPosXOnExit, _iCutPosYOnExit);
	m_pVideoExtract->put_PointerInDisable(_bPointerInDisableOnExit);
	m_pVideoExtract->put_CheckerGridXY(_iGridXOnExit, _iGridYOnExit);

    m_pVideoExtract->Release();
    m_pVideoExtract = NULL;
    return NOERROR;

} // OnDisconnect


//
// OnDeactivate
//
// We are being deactivated
//
HRESULT CVideoExtractProperties::OnDeactivate(void)
{
	pIVideoExtract()->get_OutputVideoResolution(&_iOutputVideoResolution);
	pIVideoExtract()->get_Mask(&_iMask);
	pIVideoExtract()->get_BackgroundColor(&_iBGColor);
	pIVideoExtract()->get_CutPosition(&_iCutPosX, &_iCutPosY);
	pIVideoExtract()->get_PointerInDisable(&_bPointerInDisable);
	pIVideoExtract()->get_CheckerGridXY(&_iGridX, &_iGridY);

	return NOERROR;

} // OnDeactivate


//
// OnApplyChanges
//
// Changes made should be kept. Change the m_cVideoExtractOnExit variable
//
HRESULT CVideoExtractProperties::OnApplyChanges()
{
	pIVideoExtract()->get_OutputVideoResolution(&_iOutputVideoResolutionOnExit);
	pIVideoExtract()->get_Mask(&_iMaskOnExit);
	pIVideoExtract()->get_BackgroundColor(&_iBGColorOnExit);
	pIVideoExtract()->get_CutPosition(&_iCutPosXOnExit, &_iCutPosYOnExit);
	pIVideoExtract()->get_PointerInDisable(&_bPointerInDisableOnExit);
	pIVideoExtract()->get_CheckerGridXY(&_iGridXOnExit, &_iGridYOnExit);

    m_bDirty = FALSE;
    return(NOERROR);

} // OnApplyChanges

void
CVideoExtractProperties::SetupItems()
{
	ComboBox_ResetContent(m_Dlg);
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SQCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("QCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("CIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("160x120"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("320x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("360x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("640x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("720x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("800x600"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1024x768"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1280x1024"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1600x1200"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 720p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 1080i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480i"));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("`"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("ȉ~"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("s͗l"));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _T(""));

	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _iOutputVideoResolution);
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _iMask);
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_BGCOLOR_COMBO), _iBGColor);

    TCHAR   sz[32];
    _stprintf(sz, TEXT("%d"), _iCutPosX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_CUTX_EDIT), sz);
    _stprintf(sz, TEXT("%d"), _iCutPosY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_CUTY_EDIT), sz);

	Button_SetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK), _bPointerInDisable);

	_stprintf(sz, TEXT("%d"), _iGridX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), sz);
	_stprintf(sz, TEXT("%d"), _iGridY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), sz);

}




