/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

class CVideoExtractProperties : public CBasePropertyPage
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:

    BOOL	OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT	OnConnect(IUnknown *pUnknown);
    HRESULT	OnDisconnect();
    HRESULT	OnDeactivate();
    HRESULT	OnApplyChanges();

    void	SetDirty();
	void	SetupItems();

    CVideoExtractProperties(LPUNKNOWN lpunk, HRESULT *phr);
	
	unsigned int	_iOutputVideoResolution;
	unsigned int	_iOutputVideoResolutionOnExit;
	unsigned int	_iMask;
	unsigned int	_iMaskOnExit;
	unsigned int	_iBGColor;
	unsigned int	_iBGColorOnExit;
	int				_iCutPosX;
	int				_iCutPosXOnExit;
	int				_iCutPosY;
	int				_iCutPosYOnExit;
	bool			_bPointerInDisable;
	bool			_bPointerInDisableOnExit;
	unsigned int	_iGridX;
	unsigned int	_iGridXOnExit;
	unsigned int	_iGridY;
	unsigned int	_iGridYOnExit;

    IVideoExtract *m_pVideoExtract;

    IVideoExtract *pIVideoExtract() {
        ASSERT(m_pVideoExtract);
        return m_pVideoExtract;
    };

}; // CVideoExtractProperties

