/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#ifndef __VIDEOOVERLAYMIXER_H__
#define __VIDEOOVERLAYMIXER_H__


class CPointerInputPin;
class MaskCreator;

class CVideoOverlayMixer : public CCpndBase3Filter,
		public CPersistStream, 
		public IVideoOverlayMixer,
		public ISpecifyPropertyPages
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

	// Reveals IVideoOverlayMixer & ISpecifyPropertyPages
    STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    DECLARE_IUNKNOWN;

	virtual int				GetPinCount();
	virtual CBasePin*		GetPin(int n);
	virtual STDMETHODIMP	FindPin(LPCWSTR Id, IPin **ppPin);

	HRESULT			Compound(unsigned int pinIdx, IMediaSample* pInputSample, IMediaSample* pOutputSample);
	HRESULT			FilterCompound(IMediaSample* pOutputSample);
    HRESULT			CheckInputType(const CMediaType *mtIn, unsigned int pinIdx);
	HRESULT			CheckOutputType(const CMediaType *mtOut);
	HRESULT			GetMediaType(int iPosition, CMediaType *pMediaType);
    HRESULT			DecideBufferSize(IMemAllocator *pAlloc, ALLOCATOR_PROPERTIES *pProperties);

    virtual HRESULT	SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt, unsigned int pinIdx);

	
    // IVideoOverlayMixer methods
	STDMETHODIMP	get_TimeStamp(unsigned int *timeStamp);
	STDMETHODIMP	put_TimeStamp(unsigned int timeStamp);
	STDMETHODIMP	get_TimeStampZero(bool *flag);
	STDMETHODIMP	put_TimeStampZero(bool flag);
	STDMETHODIMP	get_TimeOffset(int *timeOffset);
	STDMETHODIMP	put_TimeOffset(int timeOffset);
	STDMETHODIMP	get_FrameRate(int *rate);
	STDMETHODIMP	put_FrameRate(int rate);
	STDMETHODIMP	get_Mask(unsigned int *mask);
	STDMETHODIMP	put_Mask(unsigned int mask);
	STDMETHODIMP	get_Blending(unsigned int *blending);
	STDMETHODIMP	put_Blending(unsigned int blending);
	STDMETHODIMP	get_CompPosition(int* x, int* y);
	STDMETHODIMP	put_CompPosition(int x, int y);
	STDMETHODIMP	get_PointerInDisable(bool* flag);
	STDMETHODIMP	put_PointerInDisable(bool flag);
	STDMETHODIMP	get_CheckerGridXY(unsigned int* x, unsigned int* y);
	STDMETHODIMP	put_CheckerGridXY(unsigned int x, unsigned int y);

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();


    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// Other
	HRESULT			ReceivePointer(IMediaSample *pSource,CPointerInputPin *ppin);

	CCritSec&		getCSFilter(){ return m_csFilter; }
	CCritSec&		getCSReceive(){ return m_csReceive; }

private:

    // Constructor
    CVideoOverlayMixer(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);
	virtual ~CVideoOverlayMixer();

	HRESULT			Copy(IMediaSample *pSource, IMediaSample *pDest);
	HRESULT			Fill(IMediaSample *pDest);
	HRESULT			Compound(IMediaSample *pSource, IMediaSample *pDest);
	HRESULT			Compound(BYTE* pSourceBuffer, long lSourceSize, BYTE* pDestBuffer, long lDestSize);

	HRESULT			AllocBaseBuffer(unsigned int size);
	HRESULT			DrawBaseBufferInBGColor();
	HRESULT			AllocMaskBuffer(int width, int height, WORD bitCnt);


private:

    // Non interface locking critical section
    CCritSec			_videoOverlayMixerLock;

	CPointerInputPin	*_pPointer;

	TimeStampEnum		_timeStamp;
	MaskEnum			_mask;
	BlendingEnum		_blending;
	int					_compPosX;
	int					_compPosY;
	bool				_pointerInDisable;
	unsigned int		_gridX;
	unsigned int		_gridY;

	int					_baseBufSize;
	BYTE*				_baseBuf;

	MaskCreator*		_maskCreator;
	int*				_maskBuf;
	unsigned int		_maskBufSize;

	flPointerInfo		_pointerInfo;

	bool				_eraseBase;
	bool				_eraseAdd;
	long				_baseReceiveTime;
	long				_addReceiveTime;

	long				_srcDataLen;
	BYTE*				_srcData;

}; // CVideoOverlayMixer

class MaskCreator {

public:
	MaskCreator(unsigned int width, unsigned int height, unsigned int bCnt);
	~MaskCreator();

public:
	void		createAllMasks(unsigned int cgX, unsigned int cgY);
	void		recreateCheckerMask(unsigned int cgX, unsigned int cgY);

	void		getMask(CVideoOverlayMixer::MaskEnum mask, CVideoOverlayMixer::BlendingEnum blending, 
						int** maskBuf, unsigned int* maskBufSize);

private:
	void		createMask(int* maskBufSize, int** maskBuf, BYTE **map);
	void		getRectMap(BYTE ***map);
	void		getEllipMap(BYTE ***map);
	void		getCheckMap(BYTE ***map, unsigned int cgX, unsigned int cgY);
	void		getBlendRectMap(BYTE ***map);
	void		getBlendEllipMap(BYTE ***map);
	void		getBlendCheckMap(BYTE ***map, unsigned int cgX, unsigned int cgY);

private:
	int*				_maskBufSize;
	int**				_maskBuf;

	unsigned int		_width;
	unsigned int		_height;
	unsigned int		_bCnt;
};

class CPointerInputPin : public CBaseInputPin
{
    friend class CCpndBase3Filter;

protected:
	  CVideoOverlayMixer *m_pTransformFilter;

public:

    CPointerInputPin(
        TCHAR *pObjectName,
        CCpndBase3Filter *pTransformFilter,
        HRESULT * phr,
        LPCWSTR pName);

#if 0
    STDMETHODIMP QueryId(LPWSTR * Id)
    {
        return AMGetWideString(L"PointerIn", Id);
    }
#endif

	// Grab and release extra interfaces if required
    HRESULT CheckConnect(IPin *pPin);
    HRESULT BreakConnect();
    HRESULT CompleteConnect(IPin *pReceivePin);

    // check that we can support this output type
    HRESULT CheckMediaType(const CMediaType* mtIn);

    // set the connection media type
    HRESULT SetMediaType(const CMediaType* mt);

    // --- IMemInputPin -----

    // here's the next block of data from the stream.
    // AddRef it yourself if you need to hold it beyond the end
    // of this call.
    STDMETHODIMP Receive(IMediaSample * pSample);

    // provide EndOfStream that passes straight downstream
    // (there is no queued data)
    STDMETHODIMP EndOfStream(void);

    // passes it to CCpndBase3Filter::BeginFlush
    STDMETHODIMP BeginFlush(void);

    // passes it to CCpndBase3Filter::EndFlush
    STDMETHODIMP EndFlush(void);

    STDMETHODIMP NewSegment(
                        REFERENCE_TIME tStart,
                        REFERENCE_TIME tStop,
                        double dRate);

    // Check if it's OK to process samples
    virtual HRESULT CheckStreaming();

    // Media type
public:
    CMediaType& CurrentMediaType() { return m_mt; };

};

#endif
