/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/

#include <streams.h>
#include <commctrl.h>
#include <olectl.h>
#include <memory.h>
#include "resource.h"

#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include <flFilterCommon/flPointerInfo.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IVideoOverlayMixer.h>

#include "cpndbase3.h"

#include "videooverlaymixer.h"
#include "videooverlaymixerprop.h"


//
// CreateInstance
//
// This goes in the factory template table to create new filter instances
//
CUnknown * WINAPI CVideoOverlayMixerProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CVideoOverlayMixerProperties(lpunk, phr);
    if (punk == NULL) {
	*phr = E_OUTOFMEMORY;
    }
    return punk;

} // CreateInstance


//
// Constructor
//
CVideoOverlayMixerProperties::CVideoOverlayMixerProperties(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("VideoOverlayMixerProp"),pUnk,
                      IDD_VIDEOOVERLAYMIXERPROP,
                      IDS_TITLE),
    m_pVideoOverlayMixer(NULL)
{
    InitCommonControls();

} // (Constructor)


//
// SetDirty
//
// Sets m_bDirty and notifies the property page site of the change
//
void CVideoOverlayMixerProperties::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite) {
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

} // SetDirty


//
// OnReceiveMessage
//
// Virtual method called by base class with Window messages
//
BOOL CVideoOverlayMixerProperties::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			SetupItems();

			if (_iMask == 2)
			{
				Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), true);
			} else {
				Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), false);
			}

			if (_iTimeStamp == 2)
			{
				Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), true);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), true);
			} else {
				Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), false);
				Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), false);
			}

			return (LRESULT) 1;

		}
        case WM_COMMAND:
        {

			switch(LOWORD(wParam))
			{
			case IDC_TIME_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_TIME_COMBO));
					pIVideoOverlayMixer()->put_TimeStamp(sel);

					if (sel == 2)
					{
						Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), true);
					} else {
						Static_Enable(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TSOFFSET_STATIC), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), false);
					}


					SetDirty();
				}
				break;
			case IDC_TIMESTAMPZERO_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK)) == TRUE);
					pIVideoOverlayMixer()->put_TimeStampZero(flag);

					SetDirty();
				}
				break;
			case IDC_TIMEOFFSET_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int timeOffset;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), sz, STR_MAX_LENGTH);
					timeOffset = atoi(sz);
					pIVideoOverlayMixer()->put_TimeOffset(timeOffset);

					SetDirty();
				}
				break;
			case IDC_FRAMERATE_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int rate;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz, STR_MAX_LENGTH);
					rate = atoi(sz);
					pIVideoOverlayMixer()->put_FrameRate(rate);

					SetDirty();
				}
				break;
			case IDC_MASK_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO));
					pIVideoOverlayMixer()->put_Mask(sel);

					if (sel == 2)
					{
						Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), true);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), true);
					} else {
						Static_Enable(GetDlgItem(m_Dlg, IDC_CGRID_STATIC), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), false);
						Edit_Enable(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), false);
					}

					SetDirty();
				}
				break;
			case IDC_BLEND_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_BLEND_COMBO));
					pIVideoOverlayMixer()->put_Blending(sel);
					SetDirty();
				}
				break;
			case IDC_CUTX_EDIT:
			case IDC_CUTY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int x, y;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_CUTX_EDIT), sz, STR_MAX_LENGTH);
					x = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_CUTY_EDIT), sz, STR_MAX_LENGTH);
					y = atoi(sz);
					pIVideoOverlayMixer()->put_CompPosition(x, y);

					SetDirty();
				}
				break;
			case IDC_PINDISABLE_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					bool flag = (Button_GetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK)) == TRUE);
					pIVideoOverlayMixer()->put_PointerInDisable(flag);

					SetDirty();
				}
				break;
			case IDC_GRIDX_EDIT:
			case IDC_GRIDY_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					int x, y;

					Edit_GetText(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), sz, STR_MAX_LENGTH);
					x = atoi(sz);
					Edit_GetText(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), sz, STR_MAX_LENGTH);
					y = atoi(sz);
					pIVideoOverlayMixer()->put_CheckerGridXY(x, y);

					SetDirty();
				}
				break;
			}

			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);

} // OnReceiveMessage


//
// OnConnect
//
// Called when the property page connects to a filter
//
HRESULT CVideoOverlayMixerProperties::OnConnect(IUnknown *pUnknown)
{
    ASSERT(m_pVideoOverlayMixer == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IVideoOverlayMixer, (void **) &m_pVideoOverlayMixer);
    if (FAILED(hr)) {
        return E_NOINTERFACE;
    }

    ASSERT(m_pVideoOverlayMixer);

	m_pVideoOverlayMixer->get_TimeStamp(&_iTimeStamp);
	_iTimeStampOnExit = _iTimeStamp;

	m_pVideoOverlayMixer->get_TimeStampZero(&_bTimeStampZero);
	_bTimeStampZeroOnExit = _bTimeStampZero;

	m_pVideoOverlayMixer->get_TimeOffset(&_iTimeOffset);
	_iTimeOffsetOnExit = _iTimeOffset;

	m_pVideoOverlayMixer->get_FrameRate(&_iFrameRate);
	_iFrameRateOnExit = _iFrameRate;

	m_pVideoOverlayMixer->get_Mask(&_iMask);
	_iMaskOnExit = _iMask;

	m_pVideoOverlayMixer->get_Blending(&_iBlending);
	_iBlendingOnExit = _iBlending;

	m_pVideoOverlayMixer->get_CompPosition(&_iCompPosX, &_iCompPosY);
	_iCompPosXOnExit = _iCompPosX;
	_iCompPosYOnExit = _iCompPosY;

	m_pVideoOverlayMixer->get_PointerInDisable(&_bPointerInDisable);
	_bPointerInDisableOnExit = _bPointerInDisable;

	m_pVideoOverlayMixer->get_CheckerGridXY(&_iGridX, &_iGridY);
	_iGridXOnExit = _iGridX;
	_iGridYOnExit = _iGridY;


	return NOERROR;

} // OnConnect


//
// OnDisconnect
//
// Called when we're disconnected from a filter
//
HRESULT CVideoOverlayMixerProperties::OnDisconnect()
{
    if (m_pVideoOverlayMixer == NULL) {
        return E_UNEXPECTED;
    }

	m_pVideoOverlayMixer->put_TimeStamp(_iTimeStampOnExit);
	m_pVideoOverlayMixer->put_TimeStampZero(_bTimeStampZeroOnExit);
	m_pVideoOverlayMixer->put_TimeOffset(_iTimeOffsetOnExit);
	m_pVideoOverlayMixer->put_FrameRate(_iFrameRateOnExit);
	m_pVideoOverlayMixer->put_Mask(_iMaskOnExit);
	m_pVideoOverlayMixer->put_Blending(_iBlendingOnExit);
	m_pVideoOverlayMixer->put_CompPosition(_iCompPosXOnExit, _iCompPosYOnExit);
	m_pVideoOverlayMixer->put_PointerInDisable(_bPointerInDisableOnExit);
	m_pVideoOverlayMixer->put_CheckerGridXY(_iGridXOnExit, _iGridYOnExit);

    m_pVideoOverlayMixer->Release();
    m_pVideoOverlayMixer = NULL;
    return NOERROR;

} // OnDisconnect


//
// OnDeactivate
//
// We are being deactivated
//
HRESULT CVideoOverlayMixerProperties::OnDeactivate(void)
{
	pIVideoOverlayMixer()->get_TimeStamp(&_iTimeStamp);
	pIVideoOverlayMixer()->get_TimeStampZero(&_bTimeStampZero);
	pIVideoOverlayMixer()->get_TimeOffset(&_iTimeOffset);
	pIVideoOverlayMixer()->get_FrameRate(&_iFrameRate);
	pIVideoOverlayMixer()->get_Mask(&_iMask);
	pIVideoOverlayMixer()->get_Blending(&_iBlending);
	pIVideoOverlayMixer()->get_CompPosition(&_iCompPosX, &_iCompPosY);
	pIVideoOverlayMixer()->get_PointerInDisable(&_bPointerInDisable);
	pIVideoOverlayMixer()->get_CheckerGridXY(&_iGridX, &_iGridY);

	return NOERROR;

} // OnDeactivate


//
// OnApplyChanges
//
// Changes made should be kept. Change the m_cVideoOverlayMixerOnExit variable
//
HRESULT CVideoOverlayMixerProperties::OnApplyChanges()
{
	pIVideoOverlayMixer()->get_TimeStamp(&_iTimeStampOnExit);
	pIVideoOverlayMixer()->get_TimeStampZero(&_bTimeStampZeroOnExit);
	pIVideoOverlayMixer()->get_TimeOffset(&_iTimeOffsetOnExit);
	pIVideoOverlayMixer()->get_FrameRate(&_iFrameRateOnExit);
	pIVideoOverlayMixer()->get_Mask(&_iMaskOnExit);
	pIVideoOverlayMixer()->get_Blending(&_iBlendingOnExit);
	pIVideoOverlayMixer()->get_CompPosition(&_iCompPosXOnExit, &_iCompPosYOnExit);
	pIVideoOverlayMixer()->get_PointerInDisable(&_bPointerInDisableOnExit);
	pIVideoOverlayMixer()->get_CheckerGridXY(&_iGridXOnExit, &_iGridYOnExit);

    m_bDirty = FALSE;
    return(NOERROR);

} // OnApplyChanges

void
CVideoOverlayMixerProperties::SetupItems()
{
	ComboBox_ResetContent(m_Dlg);
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("{͉f"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("t͉f"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _T("Ǝ"));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("`"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("ȉ~"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _T("s͗l"));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BLEND_COMBO), _T("P"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_BLEND_COMBO), _T("B"));

    TCHAR   sz[32];

	// Time Stamp
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_TIME_COMBO), _iTimeStamp);
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_TIMESTAMPZERO_CHECK), _bTimeStampZero);
	// Time Offset
    _stprintf(sz, TEXT("%d"), _iTimeOffset);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_TIMEOFFSET_EDIT), sz);
	// Framerate
    _stprintf(sz, TEXT("%d"), _iFrameRate);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAMERATE_EDIT), sz);
	// Mask
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_MASK_COMBO), _iMask);
	// Blending
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_BLEND_COMBO), _iBlending);
	// Composition Position
    _stprintf(sz, TEXT("%d"), _iCompPosX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_CUTX_EDIT), sz);
    _stprintf(sz, TEXT("%d"), _iCompPosY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_CUTY_EDIT), sz);
	// Pointer Input Disable
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_PINDISABLE_CHECK), _bPointerInDisable);
	// Grid Count
	_stprintf(sz, TEXT("%d"), _iGridX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_GRIDX_EDIT), sz);
	_stprintf(sz, TEXT("%d"), _iGridY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_GRIDY_EDIT), sz);
}




